/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.dao;

import com.seeyon.ctp.common.dao.AbstractHibernateDao;
import com.seeyon.ctp.common.dao.CTPBaseHibernateDao;
import com.seeyon.ctp.common.dao.paginate.Pagination;
import com.seeyon.ctp.common.dao.support.CriteriaSetup;
import com.seeyon.ctp.common.dao.support.page.CriteriaPage;
import com.seeyon.ctp.common.dao.support.page.HqlPage;
import com.seeyon.ctp.common.dao.support.page.Page;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.Type;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class BaseHibernateDao<T>
extends AbstractHibernateDao<T>
implements CTPBaseHibernateDao<T> {
    private static Log log = CtpLogFactory.getLog(BaseHibernateDao.class);
    public static int COUNT_MODE = 1;
    public static int SCROLL_MODE = 2;
    public static int LIST_MODE = 3;

    @Override
    public Page findBy(final Map filterMap, final Map orderMap, final int pageNo, final int pageSize, final CriteriaSetup criteriaSetup) {
        return (Page)super.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = session.createCriteria(BaseHibernateDao.this.getEntityClass());
                if (!CollectionUtils.isEmpty((Map)filterMap)) {
                    try {
                        criteriaSetup.setup(criteria, filterMap);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!CollectionUtils.isEmpty((Map)orderMap)) {
                    BaseHibernateDao.this.sortCriteria(criteria, orderMap, null);
                }
                criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
                return BaseHibernateDao.this.pagedQuery(criteria, pageNo, pageSize);
            }
        });
    }

    @Override
    public Page pagedQuery(Criteria criteria, int pageNo, int pageSize) {
        return this.pagedQuery(criteria, pageNo, pageSize, COUNT_MODE);
    }

    @Override
    public Page pagedQuery(Criteria criteria, int pageNo, int pageSize, int mode) {
        return CriteriaPage.getPageInstance(criteria, pageNo, pageSize, mode);
    }

    @Override
    public Page pagedQuery(String hql, int pageNo, int pageSize, Object ... args) {
        return this.pagedQuery(hql, pageNo, pageSize, COUNT_MODE, args);
    }

    @Override
    public Page pagedQuery(final String hql, final int pageNo, final int pageSize, final int mode, final Object ... args) {
        Assert.hasText((String)hql);
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(hql);
                for (int i = 0; i < args.length; ++i) {
                    query.setParameter(i, args[i]);
                }
                if (mode == COUNT_MODE) {
                    String countQueryString = " select count (*) " + BaseHibernateDao.removeSelect(BaseHibernateDao.removeOrders(hql));
                    List countlist = BaseHibernateDao.this.getHibernateTemplate().find(countQueryString, args);
                    int totalCount = ((Number)countlist.get(0)).intValue();
                    int ps = pageSize == -1 ? totalCount : pageSize;
                    return HqlPage.getPageInstanceByCount(query, pageNo, ps, totalCount);
                }
                return HqlPage.getPageInstance(query, pageNo, pageSize, mode);
            }
        });
    }

    private static String removeSelect(String hql) {
        Assert.hasText((String)hql);
        int beginPos = hql.toLowerCase().indexOf("from");
        Assert.isTrue((beginPos != -1 ? 1 : 0) != 0, (String)(" hql : " + hql + " must has a keyword 'from'"));
        return hql.substring(beginPos);
    }

    private static String removeOrders(String hql) {
        Assert.hasText((String)hql);
        Pattern p = Pattern.compile("order\\s*by[\\w|\\W|\\s|\\S]*", 2);
        Matcher m = p.matcher(hql);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public int getQueryCount(final String qryHql, final Object[] values, final Type[] types) {
        return (Integer)super.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = BaseHibernateDao.this.createQuery(session, qryHql, values, types);
                String queryString = query.getQueryString();
                String countString = "select count(*) " + queryString;
                Query countQuery = BaseHibernateDao.this.createQuery(session, countString, values, types);
                Integer count = ((Number)countQuery.uniqueResult()).intValue();
                return count;
            }
        });
    }

    private Query createQuery(Session session, String qryHql, Object[] args, Type[] types) {
        if (args == null || types == null) {
            return session.createQuery(qryHql);
        }
        return session.createQuery(qryHql).setParameters(args, types);
    }

    protected void sortCriteria(Criteria criteria, Map sortMap) {
        if (!sortMap.isEmpty()) {
            Iterator iterator = sortMap.keySet().iterator();
            while (iterator.hasNext()) {
                String fieldName = iterator.next().toString();
                String orderType = sortMap.get(fieldName).toString();
                if ("asc".equalsIgnoreCase(orderType)) {
                    criteria.addOrder(Order.asc((String)fieldName));
                    continue;
                }
                criteria.addOrder(Order.desc((String)fieldName));
            }
        }
    }

    @Override
    public List paginate(Criteria criteria) {
        return this.paginate(criteria, null);
    }

    @Override
    public List paginate(Criteria criteria, Order order) {
        if (Pagination.isNeedCount().booleanValue()) {
            int rowCount = ((Number)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
            criteria.setProjection(null);
            Pagination.setRowCount(rowCount);
        }
        criteria.setFirstResult(Pagination.getFirstResult()).setMaxResults(Pagination.getMaxResults());
        if (order != null) {
            criteria.addOrder(order);
        }
        List result = criteria.list();
        return result;
    }

    @Override
    public List paginate(Query query) {
        if (Pagination.isNeedCount().booleanValue()) {
            String queryString = query.getQueryString();
            String countString = "select count(*) " + queryString;
            Query countQuery = this.createQuery(this.getSession(), countString, null, null);
            Integer rowCount = ((Number)countQuery.uniqueResult()).intValue();
            Pagination.setRowCount(rowCount);
        }
        query.setFirstResult(Pagination.getFirstResult()).setMaxResults(Pagination.getMaxResults());
        List result = query.list();
        return result;
    }

    @Override
    public void removeById(Long id) {
        super.delete(id);
    }

    @Override
    public void remove(Object o) {
        this.deleteObject(o);
    }

    @Override
    public void deleteObject(Object entity) {
        super.delete(entity);
    }

    @Override
    public boolean isNotUnique(final Object entity, final String names) {
        Assert.hasText((String)names);
        return (Boolean)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(entity.getClass()).setProjection(Projections.rowCount());
                String[] nameList = names.split(",");
                try {
                    Object id;
                    for (String name : nameList) {
                        criteria.add((Criterion)Restrictions.eq((String)name, (Object)PropertyUtils.getProperty((Object)entity, (String)name)));
                    }
                    String keyName = BaseHibernateDao.this.getSessionFactory().getClassMetadata(entity.getClass()).getIdentifierPropertyName();
                    if (keyName != null && (id = PropertyUtils.getProperty((Object)entity, (String)keyName)) != null) {
                        criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)keyName, (Object)id)));
                    }
                }
                catch (Exception e) {
                    BaseHibernateDao.this.logger.error((Object)e.getMessage());
                    return false;
                }
                return ((Number)criteria.uniqueResult()).intValue() > 0;
            }
        });
    }

    @Override
    public void withPagination() {
        Pagination.withPagination(this.getClass());
    }

    @Override
    public void withoutPagination() {
        Pagination.withoutPagination(this.getClass());
    }

    @Override
    public void saveAll(Collection<? extends Object> objects) {
        for (Object object : objects) {
            this.save(object);
        }
    }

    @Override
    public void updateAll(Collection<Object> entities) {
        if (entities == null) {
            return;
        }
        for (Object o : entities) {
            this.update(o);
        }
    }

    @Override
    public void update(Long id, Map<String, Object> columns) {
        this.update(this.entityClass, columns, new Object[][]{{"id", id}});
    }

    @Override
    public void update(Class entityClazz, Long id, Map<String, Object> columns) {
        this.update(entityClazz, columns, new Object[][]{{"id", id}});
    }

    @Override
    public void update(Class clazz, Map<String, Object> columns, Object[][] where) {
        if (columns == null || columns.size() == 0) {
            return;
        }
        if (where == null) {
            where = new Object[0][2];
        }
        StringBuilder sb = new StringBuilder();
        sb.append("update " + clazz.getName()).append(" a set ");
        Object[] values = new Object[columns.size() + where.length];
        Set<String> keys = columns.keySet();
        int len = keys.size();
        int i = 0;
        for (String key : keys) {
            sb.append("a." + key + "= ?");
            if (i < len - 1) {
                sb.append(", ");
            }
            values[i++] = columns.get(key);
        }
        if (where != null && where.length > 0) {
            sb.append(" where ");
            len = where.length;
            int j = 0;
            for (Object[] key : where) {
                sb.append("(a." + key[0] + "=?)");
                if (j < len - 1) {
                    sb.append(" and ");
                }
                ++j;
                values[i++] = key[1];
            }
        }
        this.getHibernateTemplate().bulkUpdate(sb.toString(), values);
    }

    @Override
    public void update(Class clazz, String[] columns, final Object[] values, final Type[] types, final Object[][] where) {
        if (columns == null || values == null || types == null || columns.length == 0 || columns.length != values.length || columns.length != types.length) {
            log.warn((Object)("Update\u5217\u6ca1\u6709\u6307\u5b9a" + clazz + ", " + columns + ", " + values + ", " + types));
            return;
        }
        final StringBuilder sb = new StringBuilder();
        sb.append("update " + clazz.getName()).append(" a set ");
        int len = columns.length;
        int i = 0;
        for (String column : columns) {
            sb.append("a." + column + "=?");
            if (i < len - 1) {
                sb.append(",");
            }
            ++i;
        }
        if (where != null && where.length > 0) {
            sb.append(" where ");
            len = where.length;
            int j = 0;
            for (Object[] key : where) {
                sb.append("(a." + key[0] + "=?)");
                if (j < len - 1) {
                    sb.append(" and ");
                }
                ++j;
            }
        }
        super.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query queryObject = session.createQuery(sb.toString());
                if (values != null) {
                    int index = 0;
                    for (Object object : values) {
                        queryObject.setParameter(index, object, types[index]);
                        ++index;
                    }
                    if (where != null) {
                        for (Object[] objects : where) {
                            queryObject.setParameter(index++, objects[1]);
                        }
                    }
                }
                return queryObject.executeUpdate();
            }
        });
    }

    @Override
    public void update(String fieldName, Object fieldValue, Map<String, Object> columns) {
        this.update(this.entityClass, columns, new Object[][]{{fieldName, fieldValue}});
    }

    @Override
    public List<T> findByExample(T o) {
        return this.getHibernateTemplate().findByExample(o);
    }

    @Override
    public void delete(Class entityType, long id) {
        this.delete(entityType, new Object[][]{{"id", id}});
    }

    @Override
    public void delete(String[] columns, Object[] values) {
        if (columns != null && columns.length > 0 && columns.length == values.length) {
            Object[][] _columns = new Object[columns.length][2];
            for (int i = 0; i < values.length; ++i) {
                _columns[i] = new Object[]{columns[i], values[i]};
            }
            this.delete(_columns);
        }
    }

    @Override
    public void delete(Object[][] where) {
        this.delete(this.entityClass, where);
    }

    @Override
    public void delete(Class entityType, Object[][] where) {
        StringBuilder sb = new StringBuilder();
        sb.append("delete from " + entityType.getName()).append(" a");
        Object[] values = null;
        if (where != null) {
            sb.append(" where ");
            values = new Object[where.length];
            int i = 0;
            int len = where.length;
            for (Object[] key : where) {
                sb.append("a." + key[0] + "=?");
                if (i < len - 1) {
                    sb.append(" AND ");
                }
                values[i++] = key[1];
            }
        }
        this.getHibernateTemplate().bulkUpdate(sb.toString(), values);
    }
}

