/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.dao.support.page;

import com.seeyon.ctp.common.dao.BaseHibernateDao;
import com.seeyon.ctp.common.dao.support.page.Page;
import com.seeyon.ctp.util.BeanUtils;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.impl.CriteriaImpl;

public class CriteriaPage {
    public static Page getPageInstance(Criteria criteria, int pageNo, int pageSize) {
        return CriteriaPage.getPageInstance(criteria, pageNo, pageSize, BaseHibernateDao.COUNT_MODE);
    }

    public static Page getPageInstance(Criteria criteria, int pageNo, int pageSize, int mode) {
        if (mode == BaseHibernateDao.COUNT_MODE) {
            return CriteriaPage.getPageInstanceByCount(criteria, pageNo, pageSize);
        }
        if (mode == BaseHibernateDao.SCROLL_MODE) {
            return CriteriaPage.getPageInstanceByScroll(criteria, pageNo, pageSize);
        }
        if (mode == BaseHibernateDao.LIST_MODE) {
            return CriteriaPage.getPageInstanceByList(criteria, pageNo, pageSize);
        }
        return null;
    }

    protected static Page getPageInstanceByCount(Criteria criteria, int pageNo, int pageSize) {
        List orderEntries;
        CriteriaImpl impl = (CriteriaImpl)criteria;
        Projection projection = impl.getProjection();
        try {
            orderEntries = (List)BeanUtils.getPrivateProperty(impl, "orderEntries");
            BeanUtils.setPrivateProperty(impl, "orderEntries", new ArrayList());
        }
        catch (Exception e) {
            throw new InternalError(" Runtime Exception impossibility throw ");
        }
        int totalCount = (Integer)criteria.setProjection(Projections.rowCount()).uniqueResult();
        criteria.setProjection(projection);
        if (projection == null) {
            criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        try {
            BeanUtils.setPrivateProperty(impl, "orderEntries", orderEntries);
        }
        catch (Exception e) {
            throw new InternalError(" Runtime Exception impossibility throw ");
        }
        return CriteriaPage.getPageResult(criteria, totalCount, pageNo, pageSize);
    }

    protected static Page getPageInstanceByScroll(Criteria criteria, int pageNo, int pageSize) {
        ScrollableResults scrollableResults = criteria.scroll(ScrollMode.SCROLL_SENSITIVE);
        scrollableResults.last();
        int totalCount = scrollableResults.getRowNumber() + 1;
        return CriteriaPage.getPageResult(criteria, totalCount, pageNo, pageSize);
    }

    protected static Page getPageInstanceByList(Criteria criteria, int pageNo, int pageSize) {
        criteria.scroll(ScrollMode.FORWARD_ONLY);
        int totalCount = criteria.list().size();
        return CriteriaPage.getPageResult(criteria, totalCount, pageNo, pageSize);
    }

    private static Page getPageResult(Criteria criteria, int totalCount, int pageNo, int pageSize) {
        if (totalCount < 1) {
            return new Page();
        }
        int startIndex = Page.getStartOfPage(pageNo, pageSize);
        List list = criteria.setFirstResult(startIndex).setMaxResults(pageSize).list();
        return new Page(startIndex, totalCount, pageSize, list);
    }
}

