/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.filemanager.dao;

import com.seeyon.ctp.common.dao.BaseHibernateDao;
import com.seeyon.ctp.common.filemanager.dao.V3XFileDAO;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.util.Strings;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Expression;

public class V3XFileDAOImpl
extends BaseHibernateDao<V3XFile>
implements V3XFileDAO {
    @Override
    public void save(V3XFile file) {
        String fileName;
        if (file.getUpdateDate() == null) {
            file.setUpdateDate(file.getCreateDate());
        }
        if ((fileName = file.getFilename()).getBytes().length > 120) {
            int pointIndex = fileName.lastIndexOf(".");
            String ext = "";
            if (pointIndex > 0) {
                ext = fileName.substring(pointIndex);
                fileName = fileName.substring(0, pointIndex);
            }
            fileName = Strings.getSafeLimitLengthString(fileName, 120, "..") + ext;
            file.setFilename(fileName);
        }
        super.getHibernateTemplate().merge((Object)file);
    }

    @Override
    public void save(List<V3XFile> files) {
        for (V3XFile file : files) {
            this.save(file);
        }
    }

    @Override
    public void delete(Long id) {
        super.delete(id);
    }

    @Override
    public V3XFile get(Long id) {
        try {
            return (V3XFile)super.get(id);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<V3XFile> get(Long[] ids) {
        if (ids == null || ids.length < 1) {
            return null;
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(V3XFile.class).add(Expression.in((String)"id", (Object[])ids));
        return super.executeCriteria(criteria, -1, -1);
    }

    @Override
    public List<V3XFile> findByFileName(String fileName) {
        DetachedCriteria criteria = DetachedCriteria.forClass(V3XFile.class).add((Criterion)Expression.eq((String)"filename", (Object)fileName));
        return super.executeCriteria(criteria, -1, -1);
    }

    @Override
    public void update(V3XFile id) {
        super.update(id);
    }
}

