/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.filemanager.manager;

import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheSet;
import com.seeyon.ctp.common.filemanager.manager.FileSecurityManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public class FileSecurityManagerImpl
implements FileSecurityManager {
    private static final Log log = CtpLogFactory.getLog(FileSecurityManagerImpl.class);
    CacheAccessable factory = CacheFactory.getInstance(FileSecurityManagerImpl.class);
    private CacheSet<Long> needLessLoginCache = this.factory.createSet("_File_SECURITY_");

    @Override
    public boolean isNeedlessLogin(Long fileId) {
        boolean isNeedlessLogin = this.needLessLoginCache.contains(fileId);
        log.info((Object)("\u5bf9\u6587\u4ef6:" + fileId + "\u8fdb\u884c\u5224\u65ad\u662f\u5426\u9700\u8981\u767b\u5f55-->" + isNeedlessLogin));
        return isNeedlessLogin;
    }

    @Override
    public void addNeedlessLogin(Long fileId) {
        this.needLessLoginCache.add(fileId);
    }

    @Override
    public void addNeedlessLogin(Collection<Long> fileIds) {
        this.needLessLoginCache.addAll(fileIds);
    }

    @Override
    public void addNeedlessLogin(String fileIdStr) {
        if (this.isNumeric(fileIdStr)) {
            try {
                Long fileId = Long.valueOf(fileIdStr);
                this.needLessLoginCache.add(fileId);
            }
            catch (Exception e) {
                log.error((Object)("\u5c06\u6587\u4ef6Id\u6dfb\u52a0\u5230\u767d\u540d\u5355\u65f6\u51fa\u9519\u4e86\uff01" + e.fillInStackTrace()));
            }
        }
    }

    private boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("-?[0-9]+");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

