/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.fileupload.util;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class FileServiceUtil {
    private static final Log LOG = CtpLogFactory.getLog(FileServiceUtil.class);
    private static String servicesConfigFilePath = AppContext.getCfgHome().getAbsolutePath() + File.separator + "base" + File.separator + "services_config.properties";
    private static boolean isLoaded = false;
    private static boolean isRemoteMode;
    public static String ip;
    public static int port;

    public static boolean isRemoteMode() {
        if (!isLoaded) {
            FileServiceUtil.loadProperties();
        }
        return isRemoteMode;
    }

    public static void switchToMode(ModeEnum mode) {
        switch (mode) {
            case LOCAL: {
                isRemoteMode = false;
                break;
            }
            case REMOTE: {
                isRemoteMode = true;
            }
        }
    }

    public static String getRequestUrl(RequestTypeEnum requestType) {
        if (!isLoaded) {
            FileServiceUtil.loadProperties();
        }
        return "http://" + ip + ":" + port + "/seeyon/fileService/" + requestType.getMethod();
    }

    public static boolean saveToProperties() {
        boolean success = false;
        FileSystemResource resource = new FileSystemResource(servicesConfigFilePath);
        try {
            Properties props = PropertiesLoaderUtils.loadProperties((Resource)resource);
            props.setProperty("file.service.switch", isRemoteMode ? "on" : "off");
            props.setProperty("file.service.ip", ip);
            props.setProperty("file.service.port", String.valueOf(port));
            props.store(new FileOutputStream(resource.getFile()), "ctp system user update config");
            success = true;
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return success;
    }

    public static String generateDownloadTicket(long fileId) {
        return FileServiceUtil.getRandomString(16);
    }

    public static void loadProperties() {
        FileSystemResource resource = new FileSystemResource(servicesConfigFilePath);
        try {
            Properties props = PropertiesLoaderUtils.loadProperties((Resource)resource);
            String switchFlag = props.getProperty("file.service.switch");
            isRemoteMode = "on".equals(switchFlag);
            ip = props.getProperty("file.service.ip");
            port = Integer.parseInt(props.getProperty("file.service.port"));
            isLoaded = true;
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static synchronized String getRandomString(int length) {
        StringBuffer buffer = new StringBuffer("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        int range = buffer.length();
        for (int i = 0; i < length; ++i) {
            sb.append(buffer.charAt(random.nextInt(range)));
        }
        return sb.toString();
    }

    public static enum ModeEnum {
        LOCAL,
        REMOTE;

    }

    public static enum RequestTypeEnum {
        GET_THRESHOLD(0, "getThreshold"),
        SET_THRESHOLD(1, "setThreshold"),
        FILE_DOWNLOAD(2, "download"),
        ADD_TICKET(3, "addDownloadTicket"),
        GET_SERVER_CONFIG(4, "getServiceConfig"),
        SET_SERVER_CONFIG(5, "updateServiceConfig"),
        SET_SERVER_PARTITIONS(6, "updatePartitions");

        private int index;
        private String method;

        private RequestTypeEnum(int index, String method) {
            this.index = index;
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

