/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.fileupload.util;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.encrypt.CoderFactory;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.filemanager.Attachment;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.springframework.web.servlet.ModelAndView;

public class FileUploadUtil {
    private static final String HEAD = "attach_";
    private static final Log log = CtpLogFactory.getLog(FileUploadUtil.class);

    public static String escapeFileName(V3XFile file) {
        String fileName = file.getFilename();
        String suffix = null;
        if (fileName.lastIndexOf(".") > 0) {
            suffix = fileName.substring(fileName.lastIndexOf("."), fileName.length());
            return HEAD + file.getId() + suffix;
        }
        return HEAD + file.getId();
    }

    public static String getOfficeHeader(String type) {
        String result = null;
        result = "OfficeWord".equals(type) ? "application/msword" : ("OfficeExcel".equals(type) ? "application/vnd.ms-excel" : ("WpsWord".equals(type) ? "application/kswps" : ("WpsExcel".equals(type) ? "application/octet-stream" : ("Pdf".equals(type) ? "application/pdf" : "application/x-msdownload"))));
        return result;
    }

    public static String getOfficeSuffix(String type) {
        String result = "OfficeWord".equals(type) ? "doc" : ("OfficeExcel".equals(type) ? "xls" : ("WpsWord".equals(type) ? "wps" : ("WpsExcel".equals(type) ? "et" : "html")));
        return result;
    }

    public static String getOfficeName(Long file, String type) {
        return file.toString() + "." + FileUploadUtil.getOfficeSuffix(type);
    }

    public static File getFile(HttpServletRequest request) throws BusinessException {
        FileManager fileManager = (FileManager)AppContext.getBean("fileManager");
        Attachment att = (Attachment)request.getAttribute("attachment");
        return fileManager.getFile(att.getFileUrl(), att.getCreatedate());
    }

    public static InputStream getInputStream(HttpServletRequest request) throws BusinessException {
        FileManager fileManager = (FileManager)AppContext.getBean("fileManager");
        Attachment att = (Attachment)request.getAttribute("attachment");
        return fileManager.getFileInputStream(att.getFileUrl(), att.getCreatedate());
    }

    public static ModelAndView downLoadStream(HttpServletRequest request, HttpServletResponse response, InputStream in, String fileName) throws BusinessException {
        request.setAttribute("filename", (Object)fileName);
        return FileUploadUtil.downLoadStream(request, response, in);
    }

    public static ModelAndView downLoadStream(HttpServletRequest request, HttpServletResponse response, InputStream in) throws BusinessException {
        String contentType = "application/x-msdownload";
        String filename = "temp" + new Date();
        if (request.getAttribute("filename") != null) {
            filename = (String)request.getAttribute("filename");
        }
        String name = filename.replace(";", "");
        try {
            name = URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301UTF-8\u7f16\u7801\u8f6c\u6362\uff1a", (Throwable)e);
        }
        response.setContentType(contentType + "; charset=UTF-8");
        response.setHeader("Content-disposition", "attachment; filename=\"" + name + "\"");
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            CoderFactory.getInstance().download(in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new BusinessException(e);
        }
        catch (Exception e) {
            throw new BusinessException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
        return null;
    }
}

