/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.function;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.formula.FormulaUtil;
import com.seeyon.ctp.common.function.CtpFunction;
import com.seeyon.ctp.common.function.CtpFunctionCategory;
import com.seeyon.ctp.common.function.CtpFunctionParameter;
import com.seeyon.ctp.common.function.manager.FunctionManager;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.AnnotationAware;
import com.seeyon.ctp.util.annotation.AnnotationFactory;
import com.seeyon.ctp.util.annotation.ClassAnnotation;
import com.seeyon.ctp.util.annotation.Function;
import com.seeyon.ctp.util.annotation.FunctionCategory;
import com.seeyon.ctp.util.annotation.FunctionParam;
import com.seeyon.ctp.util.annotation.MethodAnnotation;
import com.seeyon.ctp.util.annotation.ParameterAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassUtils;

public class CtpFunctionAnnotationAware
extends AbstractSystemInitializer
implements AnnotationAware {
    private static final Log logger = LogFactory.getLog(CtpFunctionAnnotationAware.class);
    private FunctionManager functionManager;
    private AnnotationFactory annotationFactory;

    @Override
    public void setAnnotationFactory(AnnotationFactory annotationFactory) {
        this.annotationFactory = annotationFactory;
    }

    public FunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public void setFunctionManager(FunctionManager functionManager) {
        this.functionManager = functionManager;
    }

    @Override
    public void initialize() {
        ArrayList<CtpFunction> allFunction = new ArrayList<CtpFunction>();
        ArrayList<CtpFunctionCategory> categories = new ArrayList<CtpFunctionCategory>();
        Set<ClassAnnotation> classAnnotations = this.annotationFactory.getAnnotationOfClass(FunctionCategory.class);
        Set<MethodAnnotation> methodAnnotations = this.annotationFactory.getAnnotationOfMethod(Function.class);
        Set<ParameterAnnotation> paramAnnotations = this.annotationFactory.getAnnotationOfParameter(FunctionParam.class);
        if (classAnnotations != null) {
            for (ClassAnnotation annotation : classAnnotations) {
                FunctionCategory functionCategory = (FunctionCategory)annotation.getAnnotation();
                CtpFunctionCategory category = new CtpFunctionCategory(functionCategory);
                categories.add(category);
            }
        }
        HashMap<String, CtpFunction> functionsByMethod = new HashMap<String, CtpFunction>();
        if (methodAnnotations != null) {
            for (MethodAnnotation methodAnnotation : methodAnnotations) {
                try {
                    String methodName = methodAnnotation.getMethodName();
                    Function func = (Function)methodAnnotation.getAnnotation();
                    Method method = methodAnnotation.getMethod();
                    CtpFunction f = new CtpFunction(func);
                    String aliases = f.getAliases();
                    f.setClassName(ClassUtils.getUserClass((Class)methodAnnotation.getClazz()).getName());
                    f.setMethod(methodAnnotation.getMethod());
                    f.setMethodName(methodName);
                    for (int i = 0; i < method.getParameterTypes().length; ++i) {
                        CtpFunctionParameter parameter;
                        Annotation[][] list = method.getParameterAnnotations();
                        Class<?> p = method.getParameterTypes()[i];
                        if (list[i].length > 0) {
                            FunctionParam param = (FunctionParam)method.getParameterAnnotations()[i][0];
                            parameter = new CtpFunctionParameter(param);
                        } else {
                            parameter = new CtpFunctionParameter();
                        }
                        parameter.setName("param" + (i + 1));
                        parameter.setFileType(p.toString());
                        f.getParameters().add(parameter);
                    }
                    allFunction.add(f);
                    if (Strings.isEmpty(aliases)) {
                        aliases = f.getMethodName();
                    }
                    if (functionsByMethod.containsKey(aliases)) {
                        logger.error((Object)("\u51fd\u6570\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\uff1a" + aliases + "@" + f.getClassName()));
                    }
                    functionsByMethod.put(aliases, f);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (paramAnnotations != null) {
            for (ParameterAnnotation parameterAnnotation : paramAnnotations) {
                logger.error((Object)("FunctionParam\u6ce8\u89e3\u9519\u8bef\uff0c\u9700\u8981\u5728\u6dfb\u52a0\u4e86Function\u6ce8\u89e3\u7684\u65b9\u6cd5\u4e0a\u624d\u6709\u610f\u4e49\uff1a" + parameterAnnotation));
            }
        }
        FormulaUtil.initFunctions(allFunction);
        this.functionManager.init(allFunction, categories);
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getSortOrder() {
        return -6;
    }
}

