/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n;

import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheSet;
import com.seeyon.ctp.common.config.MessageChannel;
import com.seeyon.ctp.common.config.MessageListener;
import com.seeyon.ctp.common.config.PlatformConfigUtil;
import com.seeyon.ctp.common.config.manager.ConfigManager;
import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.i18n.ResourceCache;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.expand.LoaderManager;
import com.seeyon.ctp.common.i18n.manager.I18nResourceManager;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UniqueList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;

public final class ResourceLoader {
    private static final Log log = CtpLogFactory.getLog(ResourceLoader.class);
    private static final Set<String> exportJSKeyList = new HashSet<String>();
    private static Map<String, List<String>> pluginResourceMap = new HashMap<String, List<String>>();
    private static CacheSet<String> exportJSKeyCacheSet = null;

    @Deprecated
    public static Map<String, ResourceInfo> getResources(Locale locale) {
        Map<String, ResourceInfo> map = ResourceCache.getInstance().get(locale);
        if (map == null) {
            String lang = locale.getLanguage();
            map = ResourceCache.getInstance().get(new Locale(lang));
        }
        return map;
    }

    public static String getResources(Locale locale, String key) {
        String lang;
        ResourceCache cache = ResourceCache.getInstance();
        if (!cache.containsKey(locale) && "en".equals(lang = locale.getLanguage())) {
            return cache.getValue(new Locale(lang), key);
        }
        return cache.getValue(locale, key);
    }

    public static void updateResourcesCache(Locale locale, Map<String, ResourceInfo> resourceMap) {
        ResourceCache.getInstance().put(locale, resourceMap);
    }

    public static void resetResourcesCache(Locale locale, String key) {
        ResourceCache.getInstance().remove(locale, key);
    }

    public static void initResources() {
        ConfigManager configManager = (ConfigManager)AppContext.getBean("configManager");
        String localeStr = configManager.getSystemLocales();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load locales:" + localeStr));
        }
        final UniqueList<Locale> locales = new UniqueList<Locale>();
        if (Strings.isBlank(localeStr)) {
            localeStr = "zh_CN";
        }
        if (Strings.isNotBlank(localeStr)) {
            String[] localeStrs;
            for (String l : localeStrs = localeStr.split(",")) {
                Locale locale;
                if (!Strings.isNotBlank(l) || locales.contains(locale = I18nUtil.parseLocale(l))) continue;
                locales.add(locale);
            }
        }
        LocaleContext.intAllLocales(locales);
        log.info((Object)"\u51c6\u5907\u5f02\u6b65\u52a0\u8f7d\u56fd\u9645\u5316\u8d44\u6e90...");
        new Thread("I18nLoadThread"){

            @Override
            public void run() {
                NotificationManager.getInstance().enableSend(false);
                log.info((Object)"\u5f00\u59cb\u52a0\u8f7d\u56fd\u9645\u5316\u8d44\u6e90...");
                try {
                    for (int i = 0; i < locales.size(); ++i) {
                        Locale locale = (Locale)locales.get(i);
                        ConcurrentHashMap<String, ResourceInfo> resourceMap = new ConcurrentHashMap<String, ResourceInfo>();
                        LoaderManager.loadResource(resourceMap, locale, exportJSKeyList, pluginResourceMap);
                        CacheFactory.enableCacheNotify();
                        ResourceCache.getInstance().put(locale, resourceMap);
                    }
                    ResourceBundle.clearCache();
                    ResourceLoader.initAllResourceJavaScript();
                    ResourceLoader.initPluginResourceJavaScript();
                    I18nResourceManager i18resourceManager = (I18nResourceManager)AppContext.getBean("i18nResourceManager");
                    i18resourceManager.loadFinished();
                }
                catch (Exception e) {
                    log.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                log.info((Object)"\u56fd\u9645\u5316\u8d44\u6e90\u52a0\u8f7d\u5b8c\u6210\u3002");
                if (SystemEnvironment.isDistributedMode()) {
                    while (!SystemEnvironment.isBootFinished()) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)e.getLocalizedMessage());
                        }
                    }
                    exportJSKeyCacheSet = CacheFactory.getInstance(ResourceCache.class).createSet("exportJSKeyCache");
                    exportJSKeyCacheSet.loadFromCacheCenter();
                    exportJSKeyCacheSet.addAll(exportJSKeyList);
                    if (exportJSKeyCacheSet.size() > exportJSKeyList.size()) {
                        exportJSKeyList.addAll(exportJSKeyCacheSet.toSet());
                        ResourceLoader.initAllResourceJavaScript();
                    }
                    PlatformConfigUtil.sendMessage(MessageChannel.EXPORT_JS_KEY_CHANGE, SystemEnvironment.getAppId());
                    PlatformConfigUtil.addMessageListener(MessageChannel.EXPORT_JS_KEY_CHANGE, new MessageListener(){

                        @Override
                        public void onMessage(String message) {
                            try {
                                if (message.equalsIgnoreCase(SystemEnvironment.getAppId())) {
                                    return;
                                }
                                if (exportJSKeyCacheSet != null) {
                                    exportJSKeyCacheSet.loadFromCacheCenter();
                                    exportJSKeyList.addAll(exportJSKeyCacheSet.toSet());
                                }
                                ResourceLoader.initAllResourceJavaScript();
                            }
                            catch (Exception e) {
                                log.error((Object)("process distributed message[" + (Object)((Object)MessageChannel.EXPORT_JS_KEY_CHANGE) + "] error, deatail: " + e.getLocalizedMessage()));
                            }
                        }
                    });
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initAllResourceJavaScript() {
        File base = new File(SystemEnvironment.getApplicationFolder());
        for (Locale loc : ResourceCache.getInstance().keySet()) {
            File locFile = new File(base, "i18n_" + I18nUtil.getLocalAsString(loc) + ".js");
            Writer fos = null;
            try {
                if (locFile.exists()) {
                    locFile.delete();
                }
                locFile.createNewFile();
                fos = new OutputStreamWriter((OutputStream)new FileOutputStream(locFile, false), "UTF-8");
                Map<String, ResourceInfo> resMap = ResourceCache.getInstance().get(loc);
                fos.write("var CTPLang = [];CTPLang['");
                fos.write(I18nUtil.getLocalAsString(loc));
                fos.write("'] = {");
                StringBuilder buf = new StringBuilder();
                int i = 0;
                for (String resKey : resMap.keySet()) {
                    if (!resKey.endsWith(".js") && !exportJSKeyList.contains(resKey)) continue;
                    ResourceInfo info = resMap.get(resKey);
                    buf.append('\"');
                    buf.append(resKey);
                    buf.append('\"');
                    buf.append(":\"");
                    buf.append(info.getValue().replaceAll("\"", "\\\\\"").replaceAll("\\\r", "\\\\r").replaceAll("\\\n", "\\\\n"));
                    buf.append("\",");
                    ++i;
                }
                if (i > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                    fos.write(buf.toString());
                    fos.write("};");
                    fos.flush();
                    continue;
                }
                fos.write("};");
                fos.flush();
            }
            catch (Exception e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    log.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
                }
            }
        }
        ResourceLoader.initFrountI18n(base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFrountI18n(File base) {
        String dataKey = "DATA";
        for (Locale loc : ResourceCache.getInstance().keySet()) {
            File locFile = new File(base, "i18n_init_" + I18nUtil.getLocalAsString(loc) + ".js");
            Writer fos = null;
            try {
                if (locFile.exists()) {
                    locFile.delete();
                }
                locFile.createNewFile();
                fos = new OutputStreamWriter((OutputStream)new FileOutputStream(locFile, false), "UTF-8");
                Map<String, ResourceInfo> resMap = ResourceCache.getInstance().get(loc);
                StringBuilder buf = new StringBuilder();
                buf.append("(function($) {\n");
                buf.append("var l = '").append(loc).append("';");
                buf.append("var ts = '").append(SystemEnvironment.getLastNodeStartTime()).append("';\n");
                buf.append("function i(k,v){window.localStorage.setItem('i18n_'+k,v);}\n");
                buf.append("function ii(){var s = window.localStorage;\nif(s !== 'undefined'){\n");
                buf.append("var T = 'LASTUPDATE_TIMESTAMP';\n");
                buf.append("var L = 'LASTUPDATE_LANG';\n");
                buf.append("var tv = s.getItem('i18n_'+T);\n");
                buf.append("var lv = s.getItem('i18n_'+L);\n");
                buf.append("if(tv!=null && (l==lv) && (ts<=tv)){\nreturn;\n}");
                StringBuilder sb = new StringBuilder();
                for (String resKey : resMap.keySet()) {
                    if (!resKey.endsWith(".js") && !exportJSKeyList.contains(resKey)) continue;
                    ResourceInfo info = resMap.get(resKey);
                    sb.append("|_");
                    sb.append(resKey);
                    sb.append(",");
                    sb.append(info.getValue().replaceAll("\"", "\\\\\"").replaceAll("\\\r", "\\\\r").replaceAll("\\\n", "\\\\n"));
                    sb.append("_|");
                }
                buf.append("if(typeof(s.key)!=='undefined'){for(var j=s.length-1;j>0;j--){var key = s.key(j); try{if(key.startsWith('i18n_')){ s.removeItem(key);}}catch(e){};}};i('").append(dataKey).append("',\"").append((CharSequence)sb).append("\");\n");
                buf.append("i(T,ts);\n");
                buf.append("i(L,l);\n");
                buf.append("}}\nii();\n})(jQuery);");
                fos.write(buf.toString());
                fos.flush();
            }
            catch (Exception e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    log.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFrountI18n1(File base) {
        for (Locale loc : ResourceCache.getInstance().keySet()) {
            File locFile = new File(base, "i18n_init_" + I18nUtil.getLocalAsString(loc) + ".js");
            Writer fos = null;
            try {
                if (locFile.exists()) {
                    locFile.delete();
                }
                locFile.createNewFile();
                fos = new OutputStreamWriter((OutputStream)new FileOutputStream(locFile, false), "UTF-8");
                Map<String, ResourceInfo> resMap = ResourceCache.getInstance().get(loc);
                StringBuilder buf = new StringBuilder();
                buf.append("(function($) {\n");
                buf.append("var l = '").append(loc).append("';");
                buf.append("var ts = '").append(SystemEnvironment.getLastNodeStartTime()).append("';\n");
                buf.append("function i(k,v){window.localStorage.setItem('i18n_'+k,v);}\n");
                buf.append("function ii(){var s = window.localStorage;\nif(s !== 'undefined'){\n");
                buf.append("var T = 'LASTUPDATE_TIMESTAMP';\n");
                buf.append("var L = 'LASTUPDATE_LANG';\n");
                buf.append("var tv = s.getItem('i18n_'+T);\n");
                buf.append("var lv = s.getItem('i18n_'+L);\n");
                buf.append("if(tv!=null && (l==lv) && (ts<=tv)){\nreturn;\n}");
                int i = 0;
                for (String resKey : resMap.keySet()) {
                    if (!resKey.endsWith(".js") && !exportJSKeyList.contains(resKey)) continue;
                    ResourceInfo info = resMap.get(resKey);
                    buf.append("i('");
                    buf.append(resKey);
                    buf.append("',\"");
                    buf.append(info.getValue().replaceAll("\"", "\\\\\"").replaceAll("\\\r", "\\\\r").replaceAll("\\\n", "\\\\n"));
                    buf.append("\");\n");
                    ++i;
                }
                if (i > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                buf.append("i(T,ts);\n");
                buf.append("i(L,l);\n");
                buf.append("}}\nsetTimeout(ii,1000);\n})(jQuery);");
                fos.write(buf.toString());
                fos.flush();
            }
            catch (Exception e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    log.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPluginResourceJavaScript() {
        File base = new File(SystemEnvironment.getApplicationFolder());
        for (Locale loc : ResourceCache.getInstance().keySet()) {
            try {
                for (Map.Entry<String, List<String>> entry : pluginResourceMap.entrySet()) {
                    File pluginFile;
                    String pluginId = entry.getKey();
                    List<String> entryValue = entry.getValue();
                    String fileDirPath = "";
                    fileDirPath = base + File.separator + "i18n" + File.separator + pluginId + File.separator;
                    File fileDir = new File(fileDirPath);
                    if (!fileDir.exists()) {
                        fileDir.mkdirs();
                    }
                    if ((pluginFile = new File(fileDirPath + pluginId + "_i18n_" + I18nUtil.getLocalAsString(loc) + ".js")).exists()) {
                        pluginFile.delete();
                    }
                    pluginFile.createNewFile();
                    Writer fos = null;
                    StringBuilder buf = new StringBuilder();
                    try {
                        fos = new OutputStreamWriter((OutputStream)new FileOutputStream(pluginFile, false), "UTF-8");
                        Map<String, ResourceInfo> resMap = ResourceCache.getInstance().get(loc);
                        fos.write("var CTPLang = [];CTPLang['");
                        fos.write(I18nUtil.getLocalAsString(loc));
                        fos.write("'] = {");
                        int j = 0;
                        for (int i = 0; i < entryValue.size(); ++i) {
                            String resKey = entryValue.get(i);
                            if (!resMap.containsKey(resKey)) continue;
                            ResourceInfo info = resMap.get(resKey);
                            buf.append('\"');
                            buf.append(resKey);
                            buf.append('\"');
                            buf.append(":\"");
                            buf.append(info.getValue().replaceAll("\"", "\\\\\"").replaceAll("\\\r", "\\\\r").replaceAll("\\\n", "\\\\n"));
                            buf.append("\",");
                            ++j;
                        }
                        if (j > 0) {
                            buf.deleteCharAt(buf.length() - 1);
                            fos.write(buf.toString());
                            fos.write("};");
                            fos.flush();
                            continue;
                        }
                        fos.write("};");
                        fos.flush();
                    }
                    finally {
                        if (fos == null) continue;
                        fos.close();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extportToXml(String sourceFolder) throws Exception, FileNotFoundException {
        File parentDir = new File(sourceFolder);
        File extFile = new File(sourceFolder + File.separator + "export_to_js.xml");
        if (!parentDir.exists()) {
            log.info((Object)"\u5f53\u524d\u6587\u4ef6\u5939\u4e0d\u5b58\u5728");
        } else {
            File[] listFile = parentDir.listFiles();
            OutputStreamWriter fos = new OutputStreamWriter((OutputStream)new FileOutputStream(extFile, false), "UTF-8");
            try {
                InputStream in = null;
                fos.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                fos.write("\r\n");
                fos.write("<export>");
                for (int i = 0; i < listFile.length; ++i) {
                    File file = listFile[i];
                    if (!file.getName().endsWith("_en.properties")) continue;
                    Properties prop = new Properties();
                    if (!file.exists()) continue;
                    try {
                        in = new BufferedInputStream(new FileInputStream(file.getPath()));
                        prop.load(in);
                        for (String key : prop.stringPropertyNames()) {
                            fos.write("<resKey>" + key + "</resKey>");
                            fos.write("\r\n");
                        }
                        continue;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                fos.write("</export>");
            }
            finally {
                if (fos != null) {
                    ((Writer)fos).close();
                }
            }
        }
    }
}

