/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.expand;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.expand.Loader;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.logging.Log;

public class CustomLoader
extends Loader {
    private static final Log log = CtpLogFactory.getLog(CustomLoader.class);
    private Loader loader;
    private static final String LEVEL_TYPE = "custom";

    public CustomLoader(Loader loader) {
        this.loader = loader;
        this.setResourceMap(loader.getResourceMap());
    }

    public void process() {
        try {
            File levelFile = this.getI18nBase(new File(SystemEnvironment.getPartitionPublicFolder()));
            if (levelFile != null && levelFile.exists() && levelFile.isDirectory()) {
                HashMap<String, ResourceInfo> resMap = new HashMap<String, ResourceInfo>();
                this.loadI18nResources(LEVEL_TYPE, new File(SystemEnvironment.getPartitionPublicFolder()), resMap, null);
                if (!resMap.isEmpty()) {
                    this.getResourceMap().putAll(resMap);
                }
            }
        }
        catch (BusinessException e) {
            log.error((Object)("\u83b7\u53d6\u5171\u4eab\u76ee\u5f55\u4f4d\u7f6e\u51fa\u9519" + e.getMessage()));
        }
    }

    @Override
    public void loadResource() {
        this.loader.loadResource();
        this.process();
    }

    @Override
    protected File getI18nBase(File i18nBase) {
        return new File(i18nBase, "i18n" + File.separator);
    }
}

