/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.i18n.m3;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.domain.ResourceInfo;
import com.seeyon.ctp.common.i18n.m3.M3I18nLoaderManager;
import com.seeyon.ctp.common.i18n.m3.M3I18nPathUtil;
import com.seeyon.ctp.common.i18n.m3.M3I18nResourceCacheHolder;
import com.seeyon.ctp.common.i18n.m3.M3I18nUtile;
import com.seeyon.ctp.common.i18n.util.I18nUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.PropertiesUtil;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;

public class M3CustomI18nManager {
    private static final Log log = CtpLogFactory.getLog(M3CustomI18nManager.class);
    private Object fileLock = new Object();
    private Map<Locale, Properties> propFilesCache = new HashMap<Locale, Properties>();
    private static Map<Locale, Long> lastLoadTimeMap = new ConcurrentHashMap<Locale, Long>();
    private static M3CustomI18nManager instance = null;

    public static M3CustomI18nManager getInstance() {
        if (instance == null) {
            instance = new M3CustomI18nManager();
            instance.init();
        }
        return instance;
    }

    private M3CustomI18nManager() {
    }

    private void init() {
        String customFilePath = M3I18nPathUtil.getM3I8nCustomRootPath();
        File customFileDir = new File(customFilePath);
        if (!customFileDir.exists()) {
            customFileDir.mkdirs();
        }
    }

    public void loadM3CustomI18nResources(Locale locale, Map<String, String> resourceMap) {
        ResourceBundle b;
        String resourceName = M3I18nPathUtil.getM3I18nCustomRelativePath(locale);
        String i18nPath = M3I18nPathUtil.getM3I18nCustomPathByLocal(locale);
        File i18nFile = new File(i18nPath);
        if (!i18nFile.exists()) {
            log.info((Object)("M3 \u56fd\u9645\u5316\uff1a" + resourceName + "\u4e0d\u5b58\u5728"));
            return;
        }
        String cDir = M3I18nPathUtil.getM3I8nCustomRootPath();
        File i18nBaseHome = new File(cDir);
        CTPResourceBundleControl control = new CTPResourceBundleControl(i18nBaseHome);
        try {
            b = ResourceBundle.getBundle("custom_m3I18n", locale, control);
        }
        catch (Exception e) {
            log.error((Object)("M3 \u56fd\u9645\u5316\uff1a" + e.getLocalizedMessage()), (Throwable)e);
            return;
        }
        for (String resourceKey : b.keySet()) {
            String value;
            String[] args = resourceKey.split("\\|");
            if (args == null || args.length != 3) {
                log.error((Object)("M3 \u56fd\u9645\u5316\uff1a\u81ea\u5b9a\u4e49key\u4e0d\u5bf9" + resourceName + "===" + resourceKey));
                continue;
            }
            String appID = args[0];
            String resFileName = args[1];
            String key = args[2];
            if (resourceMap.containsKey(resourceKey)) {
                log.error((Object)("M3 \u56fd\u9645\u5316\uff1a\u91cd\u590d\u5b9a\u4e49\u8d44\u6e90" + resourceName + "===" + resourceKey));
            }
            if (Strings.isEmpty(value = b.getString(resourceKey))) continue;
            resourceMap.put(resourceKey, value);
            ResourceInfo resourceInfo = M3I18nResourceCacheHolder.getResourceInfo(locale, resourceKey);
            if (resourceInfo != null && value.equals(resourceInfo.getValue())) continue;
            M3I18nUtile.addResource2Cache(locale, "custom", key, value, appID, i18nFile.getAbsolutePath(), resFileName);
        }
    }

    public void saveImportLanguage4M3(Map<String, Map<Locale, String>> importDatas, List<Locale> importLocales) throws BusinessException {
        Set<String> keys = importDatas.keySet();
        ArrayList<ResourceInfo> infos = new ArrayList<ResourceInfo>();
        int isOldExcel = 0;
        for (String key : keys) {
            for (Locale locale : importLocales) {
                ResourceInfo oldResource;
                Map<Locale, ResourceInfo> tMap;
                String itemValue;
                Map<Locale, String> item = importDatas.get(key);
                String[] keyDivide = key.split("[|]");
                if (keyDivide.length != 3) {
                    throw new BusinessException("excel import erro:key is " + key);
                }
                String uniqueKey = key;
                String itemKey = keyDivide[2];
                String fileName = keyDivide[1];
                if (isOldExcel == 0 || isOldExcel == 1) {
                    if (keyDivide[0].startsWith("${base}/upload/2007/01/01")) {
                        itemKey = keyDivide[1];
                        fileName = keyDivide[2].substring(0, keyDivide[2].length() - 1);
                        String ts = keyDivide[0];
                        String[] paths = ts.split("/");
                        if (paths.length < 5) {
                            log.info((Object)("M3 \u56fd\u9645\u5316\uff1a\u5bfc\u5165\u4f4e\u7248\u672c\u8bcd\u6761\uff0ckey\u683c\u5f0f\u4e0d\u6b63\u786e" + key));
                            continue;
                        }
                        String zipFileName = paths[paths.length - 1];
                        String zipGroup = paths[paths.length - 2];
                        M3I18nLoaderManager.M3ZipFileInfo m3ZipFileInfo = M3I18nLoaderManager.getInstance().getM3ZipInfoByGroup(zipGroup, zipFileName);
                        if (m3ZipFileInfo == null) {
                            log.info((Object)("M3 \u56fd\u9645\u5316\uff1a\u5bfc\u5165\u4f4e\u7248\u672c\u8bcd\u6761\uff0c\u5728\u5e94\u7528\u5305\u4e2d\u65e0\u6cd5\u5339\u914d" + key));
                            continue;
                        }
                        uniqueKey = m3ZipFileInfo.getAppID() + "|" + fileName + "|" + itemKey;
                    } else {
                        isOldExcel = 2;
                    }
                }
                if (Strings.isBlank(itemValue = item.get(locale)) || (tMap = M3I18nResourceCacheHolder.getM3ResourceInfoByUniqueKey(uniqueKey)) == null || (oldResource = M3I18nResourceCacheHolder.getResourceInfo(locale, uniqueKey)) != null && itemValue.equals(oldResource.getValue())) continue;
                oldResource = tMap.values().iterator().next();
                ResourceInfo info = new ResourceInfo();
                info.setUniqueKey(uniqueKey);
                info.setKey(itemKey);
                info.setValue(itemValue);
                info.setM3(true);
                info.setAppId(oldResource.getAppId());
                info.setModule(oldResource.getModule());
                info.setModuleName(oldResource.getModuleName());
                info.setLevelType("custom");
                info.setLocale(locale);
                info.setFileName(fileName);
                info.setZipFile(oldResource.getZipFile());
                info.setFilePath(M3I18nPathUtil.getM3I18nCustomPathByLocal(locale));
                info.setRelativePath(M3I18nPathUtil.getM3I18nCustomRelativePath(locale));
                infos.add(info);
                M3I18nResourceCacheHolder.saveOrUpdateResourceInfo4M3(locale, info, true);
            }
        }
        for (Locale locale : importLocales) {
            this.saveAllM3Custom(locale);
        }
        M3I18nResourceCacheHolder.updateModifTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateM3CustomItem(Locale locale, String key, String value, ResourceInfo info) {
        Object object = this.fileLock;
        synchronized (object) {
            Properties prop = this.getProperties(locale);
            prop.put(info.getUniqueKey(), value);
            File propFile = this.getCustomFile(locale);
            PropertiesUtil.saveToFile(prop, propFile, "");
            info.setFilePath(propFile.getAbsolutePath());
        }
        String relativePath = File.separator + "i18n" + File.separator + "custom_M3_" + I18nUtil.getLocalAsString(locale);
        info.setFilePath(SystemEnvironment.getApplicationFolder() + relativePath);
        info.setRelativePath(relativePath);
        info.setLevelType("custom");
        info.setRelativePath(M3I18nPathUtil.getM3I18nCustomRelativePath(locale));
        M3I18nResourceCacheHolder.saveOrUpdateM3ResourceInfo(locale, info, true);
        M3I18nResourceCacheHolder.updateModifTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAllM3Custom(Locale locale) {
        Object object = this.fileLock;
        synchronized (object) {
            List<ResourceInfo> infos = M3I18nResourceCacheHolder.queryM3ResourceByLevelType("custom", locale);
            Properties properties = new Properties();
            for (ResourceInfo resourceItem : infos) {
                properties.put(resourceItem.getUniqueKey(), resourceItem.getValue());
            }
            File propFile = this.getCustomFile(locale);
            PropertiesUtil.saveToFile(properties, propFile, "");
            this.updatePropertiesCache(locale, properties);
        }
    }

    private Properties getProperties(Locale locale) {
        boolean reload = false;
        if (!lastLoadTimeMap.containsKey(locale)) {
            reload = true;
        } else if (!this.propFilesCache.containsKey(locale)) {
            reload = true;
        } else {
            long lastModifTime;
            long lastLoadTime = lastLoadTimeMap.get(locale);
            if (lastLoadTime < (lastModifTime = M3I18nResourceCacheHolder.getModifTime())) {
                reload = true;
            }
        }
        if (reload) {
            File propFile = this.getCustomFile(locale);
            Properties prop = new Properties();
            if (propFile.exists() && propFile.isFile()) {
                prop = PropertiesUtil.getFromFile(propFile);
            }
            SortedProperties sortedProp = new SortedProperties();
            sortedProp.putAll((Map<?, ?>)prop);
            this.updatePropertiesCache(locale, sortedProp);
        }
        return this.propFilesCache.get(locale);
    }

    private void updatePropertiesCache(Locale locale, Properties properties) {
        this.propFilesCache.put(locale, properties);
        lastLoadTimeMap.put(locale, DateUtil.currentTimestamp().getTime());
    }

    private File getCustomFile(Locale locale) {
        return new File(M3I18nPathUtil.getM3I18nCustomPathByLocal(locale));
    }

    protected static class CTPResourceBundleControl
    extends ResourceBundle.Control {
        private File bundleBase;

        public CTPResourceBundleControl(File bundleBase) {
            this.bundleBase = bundleBase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            block2: {
                String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
                File f = new File(this.bundleBase, resourceName);
                if (!f.exists()) break block2;
                FileInputStream is = null;
                PropertyResourceBundle bundle = null;
                try {
                    is = new FileInputStream(f);
                    bundle = new PropertyResourceBundle(is);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                return bundle;
            }
            return null;
        }

        @Override
        public long getTimeToLive(String baseName, Locale locale) {
            return -1L;
        }
    }

    private final class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        private SortedProperties() {
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
        }
    }
}

