/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.log;

import com.seeyon.ctp.common.log.RollingDailyFileAppender;
import java.text.MessageFormat;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class DynamicWtriteLogAppender
extends RollingDailyFileAppender {
    private int type = 0;
    private String outFileName;

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String getOutFileName() {
        return this.outFileName;
    }

    public void setOutFileName(String outFileName) {
        this.outFileName = outFileName;
    }

    private synchronized void apendLog(String fileName, LoggingEvent event) {
        try {
            String oldFileName = this.getFile();
            super.setFile(fileName);
            super.activateOptions();
            super.subAppend(event);
            super.setFile(oldFileName);
        }
        catch (Exception e) {
            LogLog.error((String)"append log errro", (Throwable)e);
        }
    }

    @Override
    protected void subAppend(LoggingEvent event) {
        String outPutTagFile = null;
        if (this.getType() == 0) {
            outPutTagFile = this.getName();
        } else {
            String logName = event.getLoggerName();
            LocationInfo locationInfo = event.getLocationInformation();
            String className = null != locationInfo ? locationInfo.getClassName() : logName;
            String simpleClassName = className.substring(className.lastIndexOf(".") + 1);
            if (this.getType() == 3) {
                outPutTagFile = simpleClassName;
            } else {
                Category parentPogger = Logger.getLogger((String)logName).getParent();
                String parentLogName = null != parentPogger ? parentPogger.getName() : logName;
                String subPackage = className.replace(parentLogName, "").replaceFirst("\\.", "");
                String[] packStructure = subPackage.split("\\.");
                int structLenth = packStructure.length;
                outPutTagFile = this.getType() == 1 ? (structLenth > 1 ? packStructure[0] : null) : (structLenth > 1 ? packStructure[structLenth - 1] : null);
            }
        }
        MessageFormat formatter = new MessageFormat(null == outPutTagFile ? this.getFile() : this.getOutFileName());
        this.apendLog(formatter.format(new String[]{outPutTagFile}), event);
    }
}

