/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.metadata;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.metadata.Column;
import com.seeyon.ctp.common.metadata.MetadataOldUtil;
import com.seeyon.ctp.common.metadata.Table;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.DirectoryScanner;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MetadataInitializer
extends AbstractSystemInitializer {
    private static final Log LOGGER = CtpLogFactory.getLog(MetadataInitializer.class);

    @Override
    public void destroy() {
    }

    @Override
    public void initialize() {
        this.init(AppContext.getCfgHome().getAbsolutePath());
    }

    public void init(String cfgHome) {
        HashMap<String, Table> meta = new HashMap<String, Table>();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(cfgHome);
        ds.setIncludes(new String[]{"metadata/*.xml", "plugin/*/metadata/*.xml"});
        ds.scan();
        String[] files = ds.getIncludedFiles();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < files.length; ++i) {
            sb.append(files[i]).append(";");
            this.merge(this.parse(cfgHome + "/" + files[i]), meta);
        }
        LOGGER.info((Object)("init metadata from:" + sb));
        MetadataOldUtil.init(meta);
    }

    private void merge(Map<String, Table> from, Map<String, Table> to) {
        for (Map.Entry<String, Table> entry : from.entrySet()) {
            String key = entry.getKey();
            if (to.containsKey(key)) {
                LOGGER.error((Object)("\u5ffd\u7565\u51b2\u7a81\u7684Metadata\u5b9a\u4e49\uff1a" + key));
                continue;
            }
            to.put(key, entry.getValue());
        }
    }

    private Map<String, Table> parse(String path) {
        HashMap<String, Table> meta = new HashMap<String, Table>();
        try {
            SAXReader builder = new SAXReader();
            Document doc = builder.read(new File(path));
            Element root = doc.getRootElement();
            List childrenList = root.elements("table");
            for (Element child : childrenList) {
                Table table = this.parseTable(child);
                if (table == null) continue;
                meta.put(table.getName(), table);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error parsing XML file:" + path), (Throwable)e);
        }
        return meta;
    }

    private Table parseTable(Element element) {
        List children = element.elements("column");
        ArrayList<Column> columns = new ArrayList<Column>(children.size());
        for (Element child : children) {
            Column c = this.parseColumn(child);
            if (c == null) continue;
            columns.add(c);
        }
        Table table = new Table(columns);
        String name = element.attributeValue("name");
        if (name == null) {
            LOGGER.warn((Object)("table\u672a\u6307\u5b9aname\uff0c\u5ffd\u7565\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u3002" + element.getDocument()));
            return null;
        }
        table.setName(name);
        String className = element.attributeValue("class");
        table.setClassName(className);
        return table;
    }

    private Column parseColumn(Element element) {
        String datatype;
        String sort;
        Column column = new Column();
        String name = element.attributeValue("name");
        if (name == null) {
            LOGGER.warn((Object)("column\u672a\u6307\u5b9aname\uff0c\u5ffd\u7565\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u3002" + element.getDocument()));
            return null;
        }
        column.setName(name);
        column.setAlias(element.elementText("alias"));
        column.setLabel(element.elementText("label"));
        column.setRule(element.elementText("rule"));
        column.setComponent(element.elementText("component"));
        String type = element.elementText("type");
        if (type != null) {
            column.setType(Integer.parseInt(type));
        }
        if ((sort = element.elementText("sort")) != null) {
            column.setSort(Integer.parseInt(sort));
        }
        if ((datatype = element.elementText("datatype")) != null) {
            column.setDataType(Integer.parseInt(datatype));
        }
        return column;
    }
}

