/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.metadata.dao;

import com.seeyon.ctp.common.dao.AbstractHibernateDao;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.metadata.dao.MetadataColumnDao;
import com.seeyon.ctp.common.metadata.util.HqlBuildUtil;
import com.seeyon.ctp.common.po.metadata.CtpMetadataColumn;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class MetadataColumnDaoImpl
extends AbstractHibernateDao<CtpMetadataColumn>
implements MetadataColumnDao {
    public static final String CTP_METADATA_COLUMN_ALIAS = "cmc";

    @Override
    public CtpMetadataColumn getById(Long id) throws BusinessException {
        return (CtpMetadataColumn)super.get(id);
    }

    @Override
    public Integer getMaxColumnSort(Long tableId) throws BusinessException {
        Integer sort = 0;
        HashMap<String, Object> sqlParams = new HashMap<String, Object>();
        if (tableId != null) {
            sqlParams.put("tableId", tableId);
        }
        StringBuilder hqlStr = new StringBuilder();
        hqlStr.append(HqlBuildUtil.getTableQueryHql(CtpMetadataColumn.class.getName(), "sort", CTP_METADATA_COLUMN_ALIAS, "max"));
        this.buildQueryCtpMetadataColumnConditionHql(hqlStr, sqlParams);
        List sortList = DBAgent.find(hqlStr.toString(), sqlParams);
        if (CollectionUtils.isNotEmpty((Collection)sortList)) {
            sort = (Integer)sortList.get(0);
        }
        return sort;
    }

    @Override
    public List<CtpMetadataColumn> findCtpMetadataColumnListByTableId(Long tableId) throws BusinessException {
        return this.findCtpMetadataColumnListByTableId(null, tableId);
    }

    @Override
    public List<CtpMetadataColumn> findCtpMetadataColumnListByTableId(FlipInfo fi, Long tableId) throws BusinessException {
        HashMap<String, Object> sqlParams = new HashMap<String, Object>();
        if (tableId != null) {
            sqlParams.put("tableId", tableId);
        }
        return this.findCtpMetadataColumnList(fi, sqlParams);
    }

    @Override
    public List<CtpMetadataColumn> findCtpMetadataColumnList(FlipInfo fi, Map<String, Object> sqlParams) throws BusinessException {
        StringBuilder hqlStr = new StringBuilder();
        hqlStr.append(this.getQueryCtpMetadataColumnHql());
        boolean labelSearch = false;
        String searchValue = "";
        if (sqlParams.containsKey("label")) {
            labelSearch = true;
            searchValue = sqlParams.get("label").toString();
            sqlParams.remove("label");
        }
        this.buildQueryCtpMetadataColumnConditionHql(hqlStr, sqlParams);
        hqlStr.append(" order by ").append(CTP_METADATA_COLUMN_ALIAS).append(".sort asc,").append(CTP_METADATA_COLUMN_ALIAS).append(".createTime asc");
        List ctpMetadataColumnList = DBAgent.find(hqlStr.toString(), sqlParams, fi);
        if (labelSearch && !"".equals(searchValue)) {
            ArrayList<CtpMetadataColumn> result = new ArrayList<CtpMetadataColumn>();
            for (CtpMetadataColumn c : ctpMetadataColumnList) {
                String labelName = c.getLabel();
                if (labelName.indexOf(searchValue) < 0) continue;
                result.add(c);
            }
            fi.setData(result);
            return result;
        }
        return ctpMetadataColumnList;
    }

    @Override
    public Long createCtpMetadataColumn(CtpMetadataColumn ctpMetadataColumn) throws BusinessException {
        Long id = -1L;
        if (ctpMetadataColumn != null) {
            id = (Long)DBAgent.save(ctpMetadataColumn);
        }
        return id;
    }

    @Override
    public void updateCtpMetadataColumn(CtpMetadataColumn ctpMetadataColumn) throws BusinessException {
        if (ctpMetadataColumn != null) {
            DBAgent.update(ctpMetadataColumn);
        }
    }

    @Override
    public void updateMetadataColumnSort(Integer sort, Long tableId) throws BusinessException {
        StringBuilder hqlSbr = new StringBuilder();
        HashMap<String, Object> sqlParams = new HashMap<String, Object>();
        if (sort != null) {
            hqlSbr.append("UPDATE ").append(CtpMetadataColumn.class.getCanonicalName());
            hqlSbr.append(" SET sort = sort+1 ");
            hqlSbr.append(" WHERE sort >= :sort and isDelete <> 1 and tableId = :tableId");
            sqlParams.put("sort", sort);
            sqlParams.put("tableId", tableId);
            DBAgent.bulkUpdate(hqlSbr.toString(), sqlParams);
        }
    }

    @Override
    public void deleteColumn(List<Long> idList) throws BusinessException {
        StringBuilder hqlSbr = new StringBuilder();
        HashMap<String, Object> sqlParams = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(idList)) {
            hqlSbr.append("UPDATE ").append(CtpMetadataColumn.class.getCanonicalName());
            hqlSbr.append(" SET isDelete = 1,isEnable = 0");
            hqlSbr.append(" WHERE id in (:idList)");
            sqlParams.put("idList", idList);
            DBAgent.bulkUpdate(hqlSbr.toString(), sqlParams);
        }
    }

    @Override
    public Collection<CtpMetadataColumn> getColumns(Long tableId) throws BusinessException {
        return super.findBy("tableId", tableId);
    }

    private void buildQueryCtpMetadataColumnConditionHql(StringBuilder hqlStr, Map<String, Object> sqlParams) {
        if (hqlStr != null && hqlStr.length() != 0 && MapUtils.isNotEmpty(sqlParams)) {
            sqlParams.put("isDelete", 1);
            for (String key : sqlParams.keySet()) {
                boolean isWhere = hqlStr.toString().indexOf("where") < 0;
                String operatorStr = "=";
                if ("isDelete".equals(key)) {
                    operatorStr = "<>";
                }
                if ("label".equals(key)) {
                    operatorStr = "like";
                }
                hqlStr.append(HqlBuildUtil.buildConditionHql(isWhere, CTP_METADATA_COLUMN_ALIAS, operatorStr, key));
            }
        }
    }

    private String getQueryCtpMetadataColumnHql() {
        return HqlBuildUtil.getTableQueryHql(CtpMetadataColumn.class.getName(), null, CTP_METADATA_COLUMN_ALIAS, null);
    }

    @Override
    public List<CtpMetadataColumn> findAll() {
        return super.getAll();
    }
}

