/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.metadata.manager;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.metadata.bo.MetadataCategoryBO;
import com.seeyon.ctp.common.metadata.dao.MetadataCategoryDao;
import com.seeyon.ctp.common.metadata.manager.MetadataCategoryManager;
import com.seeyon.ctp.common.metadata.util.ConvertMetadataUtil;
import com.seeyon.ctp.common.po.metadata.CtpMetadataCategory;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

@ProcessInDataSource(name=DataSourceName.BASE)
public class MetadataCategoryManagerImpl
extends AbstractSystemInitializer
implements MetadataCategoryManager {
    public MetadataCategoryDao metadataCategoryDao;
    private CacheMap<Long, CtpMetadataCategory> cache;

    @Override
    public void initialize() {
        CacheAccessable factory = CacheFactory.getInstance(MetadataCategoryManager.class);
        this.cache = factory.createMap("MetadataCategory");
        List<CtpMetadataCategory> all = this.metadataCategoryDao.findAll();
        for (CtpMetadataCategory category : all) {
            this.cache.put(category.getId(), category);
        }
    }

    @Override
    public MetadataCategoryBO getCategoryById(Long id) throws BusinessException {
        CtpMetadataCategory ctpMetadataCategory = this.cache.get(id);
        if (ctpMetadataCategory == null) {
            ctpMetadataCategory = this.metadataCategoryDao.getById(id);
        }
        return ConvertMetadataUtil.convertToMetadataCategoryBO(ctpMetadataCategory);
    }

    @Override
    public String getCategoryByIdToJSON(String categoryId) throws BusinessException {
        String jsonStr = null;
        if (Strings.isNotEmpty(categoryId)) {
            jsonStr = JSONUtil.toJSONString(this.getCategoryById(Long.parseLong(categoryId)));
        }
        return jsonStr;
    }

    private List<CtpMetadataCategory> getCategoryListFromCache(Map<String, Object> params) {
        int moduleType = (Integer)params.get("moduleType");
        ArrayList<CtpMetadataCategory> result = new ArrayList<CtpMetadataCategory>();
        for (CtpMetadataCategory category : this.cache.values()) {
            if (moduleType != category.getModuleType()) continue;
            result.add(category);
        }
        return result;
    }

    @Override
    public FlipInfo findMetadataCategoryList(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        if (fi != null && MapUtils.isNotEmpty(params)) {
            fi.setParams(params);
        }
        this.filterQueryParam(params);
        List<MetadataCategoryBO> metadataCategoryBOList = ConvertMetadataUtil.convertToMetadataCategoryBOList(this.getCategoryListFromCache(params));
        if (CollectionUtils.isNotEmpty(metadataCategoryBOList) && fi != null) {
            fi.setData(metadataCategoryBOList);
        }
        return fi;
    }

    @Override
    public String findMetadataCategoryListToJSON(Map<String, Object> params) throws BusinessException {
        String jsonStr = null;
        if (MapUtils.isNotEmpty(params)) {
            this.filterQueryParam(params);
            List<MetadataCategoryBO> metadataCategoryBOList = ConvertMetadataUtil.convertToMetadataCategoryBOList(this.getCategoryListFromCache(params));
            if (CollectionUtils.isNotEmpty(metadataCategoryBOList)) {
                jsonStr = JSONUtil.toJSONString(metadataCategoryBOList);
            }
        }
        return jsonStr;
    }

    @Override
    public Boolean saveCtpMetadataCategory(Map<String, Object> params) throws BusinessException {
        MetadataCategoryBO metadataCategoryBO;
        CtpMetadataCategory ctpMetadataCategory;
        Boolean bool = false;
        if (MapUtils.isNotEmpty(params) && (ctpMetadataCategory = ConvertMetadataUtil.convertToCtpMetadataCategory(metadataCategoryBO = (MetadataCategoryBO)ParamUtil.mapToBean(params, MetadataCategoryBO.class, true))) != null) {
            if (ctpMetadataCategory.getId() == null || ctpMetadataCategory.getId() == -1L) {
                ctpMetadataCategory.setNewId();
                ctpMetadataCategory.setCreateTime(DateUtil.currentDate());
                ctpMetadataCategory.setUpdateTime(DateUtil.currentDate());
                Long categoryId = this.metadataCategoryDao.createCtpMetadataCategory(ctpMetadataCategory);
                bool = categoryId != -1L;
            } else {
                String createTimeStr = ParamUtil.getString(params, "createTime");
                if (Strings.isNotEmpty(createTimeStr)) {
                    ctpMetadataCategory.setCreateTime(Datetimes.parse(createTimeStr));
                }
                ctpMetadataCategory.setUpdateTime(DateUtil.currentDate());
                this.metadataCategoryDao.updateCtpMetadataCategory(ctpMetadataCategory);
                bool = true;
            }
            this.cache.put(ctpMetadataCategory.getId(), ctpMetadataCategory);
        }
        return bool;
    }

    @Override
    public void deleteMetadataCategory(String idStr) throws BusinessException {
        if (Strings.isNotEmpty(idStr)) {
            String[] idArray = idStr.split(",");
            ArrayList<Long> idList = new ArrayList<Long>();
            for (int i = 0; i < idArray.length; ++i) {
                idList.add(Long.parseLong(idArray[i]));
            }
            this.metadataCategoryDao.deleteCategory(idList);
            this.cache.removeAll(idList);
        }
    }

    private void filterQueryParam(Map<String, Object> params) {
        if (MapUtils.isNotEmpty(params)) {
            String moduleTypeStr = ParamUtil.getString(params, "moduleType", "0");
            params.put("moduleType", Integer.parseInt(moduleTypeStr));
        }
    }

    public MetadataCategoryDao getMetadataCategoryDao() {
        return this.metadataCategoryDao;
    }

    public void setMetadataCategoryDao(MetadataCategoryDao metadataCategoryDao) {
        this.metadataCategoryDao = metadataCategoryDao;
    }
}

