/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.mq;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.mq.MapMessage;
import com.seeyon.ctp.common.mq.Message;
import com.seeyon.ctp.common.mq.ObjectMessage;
import com.seeyon.ctp.common.mq.Producer;
import com.seeyon.ctp.common.mq.TextMessage;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;

public class ActiveMQProducer
extends Producer {
    private Session session;
    private MessageProducer realProducer;

    public Session getSession() {
        return this.session;
    }

    public ActiveMQProducer setSession(Session session) {
        this.session = session;
        return this;
    }

    public MessageProducer getRealProducer() {
        return this.realProducer;
    }

    public ActiveMQProducer setRealProducer(MessageProducer realProducer) {
        this.realProducer = realProducer;
        return this;
    }

    @Override
    public void sendQueueMessage(String channel, Message message) throws BusinessException {
        try {
            Queue destination = this.session.createQueue(channel);
            javax.jms.Message msg = this.undressMessage(message);
            this.realProducer = this.session.createProducer((Destination)destination);
            this.realProducer.send((Destination)destination, msg);
        }
        catch (JMSException e) {
            throw new BusinessException(e);
        }
    }

    @Override
    public void sendTopicMessage(String channel, Message message) throws BusinessException {
        try {
            Topic destination = this.session.createTopic(channel);
            javax.jms.Message msg = this.undressMessage(message);
            this.realProducer = this.session.createProducer((Destination)destination);
            this.realProducer.send((Destination)destination, msg);
        }
        catch (JMSException e) {
            throw new BusinessException(e);
        }
    }

    private javax.jms.Message undressMessage(Message message) throws JMSException {
        javax.jms.TextMessage msg = null;
        if (message instanceof TextMessage) {
            msg = this.session.createTextMessage(((TextMessage)message).getText());
            msg.setStringProperty("key", message.getKey());
        } else if (message instanceof MapMessage) {
            msg = this.session.createObjectMessage((Serializable)((MapMessage)message).getMapData());
            msg.setStringProperty("key", message.getKey());
        } else if (message instanceof ObjectMessage) {
            msg = this.session.createObjectMessage(((ObjectMessage)message).getObject());
            msg.setStringProperty("key", message.getKey());
        }
        return msg;
    }
}

