/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.parser;

import RedOffice.Archive.XML.RedXArchive;
import RedOffice.Archive.XML.RedXWriterContentHandler;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.parser.IFileParser;
import com.seeyon.ctp.util.XXEUtil;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SXWFileParser
implements IFileParser {
    private static final Log log = CtpLogFactory.getLog(SXWFileParser.class);
    private File file;
    private String title;
    private Map metadata;
    private XMLReader reader;
    private RedXWriterContentHandler handle;
    private RedXArchive redXArchive;

    public SXWFileParser(File file) {
        try {
            this.setFile(file);
            String s = file.getAbsolutePath();
            this.redXArchive = new RedXArchive(s);
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/validation", false);
            this.reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            this.reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            this.reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            XXEUtil.prevent(this.reader);
            this.handle = new RedXWriterContentHandler();
            this.reader.setContentHandler((ContentHandler)this.handle);
            this.reader.setEntityResolver((EntityResolver)this.handle);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void setFile(File file) {
        this.file = file;
        this.title = file.getName();
        this.metadata = new HashMap();
    }

    @Override
    public String getTitle() {
        String s = "";
        try {
            this.reader.parse(new InputSource(this.redXArchive.getMeta()));
            s = this.handle.getTitle();
            if (s.length() == 0) {
                s = this.title;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return s;
    }

    public String getDescription() {
        String s = "";
        try {
            this.reader.parse(new InputSource(this.redXArchive.getMeta()));
            s = this.handle.getDescription().toString();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return s;
    }

    public String getAuthor() {
        String s = "";
        try {
            this.reader.parse(new InputSource(this.redXArchive.getMeta()));
            s = this.handle.getAuthor();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return s;
    }

    @Override
    public String getContentString() {
        String s = "";
        try {
            this.reader.parse(new InputSource(this.redXArchive.getContent()));
            s = this.handle.getText().toString();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return s;
    }

    @Override
    public Reader getContentReader() {
        String s = this.getContentString();
        StringReader reader = null;
        if (s != null) {
            reader = new StringReader(s);
        }
        return reader;
    }

    @Override
    public String getMetadata(String metadataname) {
        return (String)this.metadata.get(metadataname);
    }
}

