/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.parser;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.encrypt.CoderFactory;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.parser.HTMLFileParser;
import com.seeyon.ctp.common.parser.OfficeExtractor;
import com.seeyon.ctp.common.parser.PDFFileParser;
import com.seeyon.ctp.common.parser.RTFFileParser;
import com.seeyon.ctp.common.parser.TXTFileParser;
import com.seeyon.ctp.common.parser.UnknowBodyTypeException;
import com.seeyon.ctp.common.parser.WPSFileParser;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;

public class StrExtractor {
    private static final Log log = CtpLogFactory.getLog(StrExtractor.class);
    private static FileManager fileManager;

    private static void initManager() {
        if (fileManager == null) {
            fileManager = (FileManager)AppContext.getBean("fileManager");
        }
    }

    public static String getText(String bodyType, String bodyContent, Date bodyCreateDate) throws UnknowBodyTypeException {
        try {
            if ("HTML".equals(bodyType)) {
                return StrExtractor.getHTMLContent(bodyContent);
            }
            StrExtractor.initManager();
            if ("OfficeWord".equals(bodyType)) {
                File file = fileManager.getStandardOffice(Long.parseLong(bodyContent), bodyCreateDate);
                return StrExtractor.getDOCContent(file);
            }
            if ("OfficeExcel".equals(bodyType)) {
                File file = fileManager.getStandardOffice(Long.parseLong(bodyContent), bodyCreateDate);
                return StrExtractor.getXLSContent(file, "application/vnd.ms-excel");
            }
            if ("WpsExcel".equals(bodyType)) {
                File file = fileManager.getStandardOffice(Long.parseLong(bodyContent), bodyCreateDate);
                return StrExtractor.getWpsExcelContent(file);
            }
            if ("WpsWord".equals(bodyType)) {
                File file = fileManager.getStandardOffice(Long.parseLong(bodyContent), bodyCreateDate);
                return StrExtractor.getWpsWordContent(file);
            }
            throw new UnknowBodyTypeException(bodyType);
        }
        catch (UnknowBodyTypeException e) {
            throw new UnknowBodyTypeException(bodyType);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static String getWpsExcelContent(File file) {
        try {
            new WPSFileParser();
            return WPSFileParser.getWPSExcelContent(file);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static String getWpsWordContent(File file) {
        try {
            new WPSFileParser();
            return WPSFileParser.getWPSWordContent(file);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static String getHTMLContent(String content) {
        if (Strings.isBlank(content)) {
            return content;
        }
        HTMLFileParser parser = new HTMLFileParser();
        parser.setStr(content);
        String theContent = OfficeExtractor.docTextFilter(parser.getContentString());
        return theContent;
    }

    public static String getPDFContent(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        PDFFileParser parser = new PDFFileParser();
        parser.setFile(file);
        return parser.getContentString();
    }

    public static String getDOCContent(File file) {
        return StrExtractor.getOfficeContent(file, new String[0]);
    }

    public static String getRTFContent(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        RTFFileParser parser = new RTFFileParser();
        parser.setFile(file);
        return parser.getContentString();
    }

    public static String getXLSContent(File file, String ... mimeType) {
        return StrExtractor.getOfficeContent(file, mimeType);
    }

    public static String getTXTContent(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        TXTFileParser parser = new TXTFileParser();
        parser.setFile(file);
        return parser.getContentString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHtmlORTxtContent(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        HTMLFileParser parser = new HTMLFileParser();
        FileInputStream input = null;
        try {
            String encoding = null;
            try {
                encoding = FileUtil.detectEncoding(file.getAbsolutePath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            input = new FileInputStream(file);
            byte[] byteValues = new byte[(int)file.length()];
            input.read(byteValues);
            String s = CoderFactory.getInstance().download(byteValues);
            String htmlStr = encoding == null ? s : new String(s.getBytes(), encoding);
            parser.setStr(htmlStr);
        }
        catch (Throwable e) {
            log.error((Object)"", e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        String theContent = parser.getContentString().replaceAll("[\\t\\n\\x0B\\f\\r]", "").replaceAll("null", "");
        return theContent;
    }

    public static String getPPTContent(File file) {
        return StrExtractor.getOfficeContent(file, new String[0]);
    }

    public static String getVisioContent(File file) {
        return StrExtractor.getOfficeContent(file, new String[0]);
    }

    public static String getOfficeContent(File file, String ... mimeType) {
        if (file == null || !file.exists()) {
            return null;
        }
        OfficeExtractor extractor = new OfficeExtractor();
        extractor.setFile(file);
        return extractor.getContentString(mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getV3XFileContent(V3XFile v3xFile) {
        String mimeType = v3xFile.getMimeType();
        Long fileId = v3xFile.getId();
        Date createDate = v3xFile.getCreateDate();
        StrExtractor.initManager();
        if ("text/plain".endsWith(mimeType)) {
            String string;
            String c = null;
            InputStream in = null;
            try {
                in = fileManager.getFileInputStream(fileId, createDate);
                if (in == null) {
                    String string2 = null;
                    return string2;
                }
                c = IOUtils.toString((InputStream)in);
                string = StrExtractor.getHTMLContent(c);
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return string;
        }
        if ("application/msword".equals(mimeType) || "application/vnd.openxmlformats-officedocument.wordprocessingml.document".equals(mimeType) || "application/vnd.ms-excel".equals(mimeType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(mimeType) || "application/vnd.ms-powerpoint".equals(mimeType) || "application/vnd.openxmlformats-officedocument.presentationml.presentation".equals(mimeType) || "application/vnd.visio".equals(mimeType)) {
            try {
                File file = fileManager.getFile(fileId, createDate);
                return StrExtractor.getOfficeContent(file, mimeType);
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return null;
    }
}

