/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.parser;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.parser.EncodingDetect;
import com.seeyon.ctp.common.parser.IFileParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class TXTFileParser
implements IFileParser {
    private static final Log log = CtpLogFactory.getLog(TXTFileParser.class);
    private File file;
    private String title;
    private Map metadata;

    public TXTFileParser() {
    }

    public TXTFileParser(File file) {
        this.setFile(file);
    }

    @Override
    public void setFile(File file) {
        this.file = file;
        this.title = file.getName();
        this.metadata = new HashMap();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContentString() {
        StringBuffer buffer = new StringBuffer();
        FileInputStream input = null;
        String encode = EncodingDetect.getJavaEncode(this.file);
        try {
            String line;
            input = new FileInputStream(this.file);
            InputStreamReader reader = new InputStreamReader((InputStream)input, encode);
            BufferedReader br = new BufferedReader(reader);
            byte[] byteValues = new byte[(int)this.file.length()];
            while ((line = br.readLine()) != null) {
                if (buffer.length() >= byteValues.length) continue;
                buffer.append(line);
            }
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (Exception exception) {}
            }
        }
        return buffer.toString();
    }

    @Override
    public Reader getContentReader() {
        FileReader reader = null;
        try {
            reader = new FileReader(this.file);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return reader;
    }

    @Override
    public String getMetadata(String metadataname) {
        return (String)this.metadata.get(metadataname);
    }
}

