/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.po.applog;

import com.seeyon.ctp.common.appLog.AppLogAction;
import com.seeyon.ctp.common.flag.SysFlag;
import com.seeyon.ctp.common.i18n.ResourceBundleUtil;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.po.BasePO;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AppLog
extends BasePO
implements Serializable {
    private static final long serialVersionUID = -11849061388999971L;
    private static final String resource_common_baseName = "com.seeyon.v3x.system.resources.i18n.SysMgrResources";
    private Integer moduleId;
    private Integer actionId;
    private Long actionUserId;
    private Long actionDepartmentId = -1L;
    private Long actionAccountId = -1L;
    private String IP;
    private String param0;
    private String param1;
    private String param2;
    private String param3;
    private String param4;
    private String param5;
    private Date actionDate;
    private String actionType;
    private String actionDesc;
    private String moduleName;
    private Integer actionUserType;

    public AppLog() {
    }

    public AppLog(Integer actionId, Long actionUserId, Long actionDepartmentId, Long actionAccountId, String IP2, String ... params) {
        this.moduleId = Integer.valueOf(actionId / 100) * 100;
        if (this.moduleId < 0) {
            this.moduleId = 0 - this.moduleId;
        }
        this.actionId = actionId;
        this.actionDepartmentId = actionDepartmentId == null ? -1L : actionDepartmentId;
        this.actionUserId = actionUserId;
        this.actionAccountId = actionAccountId == null ? -1L : actionAccountId;
        this.IP = IP2;
        this.setParams(params);
    }

    public AppLog(Integer actionId, Long actionUserId, Long actionDepartmentId, Long actionAccountId, String IP2, Integer actionUserType, String ... params) {
        this.moduleId = Integer.valueOf(actionId / 100) * 100;
        if (this.moduleId < 0) {
            this.moduleId = 0 - this.moduleId;
        }
        this.actionId = actionId;
        this.actionDepartmentId = actionDepartmentId == null ? -1L : actionDepartmentId;
        this.actionUserId = actionUserId;
        this.actionAccountId = actionAccountId == null ? -1L : actionAccountId;
        this.IP = IP2;
        this.actionUserType = actionUserType;
        this.setParams(params);
    }

    public Long getActionAccountId() {
        return this.actionAccountId;
    }

    public void setActionAccountId(Long actionAccountId) {
        this.actionAccountId = actionAccountId;
    }

    public Date getActionDate() {
        return this.actionDate;
    }

    public void setActionDate(Date actionDate) {
        this.actionDate = actionDate;
    }

    public Integer getActionId() {
        return this.actionId;
    }

    public void setActionId(Integer actionId) {
        this.actionId = actionId;
    }

    public Long getActionUserId() {
        return this.actionUserId;
    }

    public void setActionUserId(Long actionUserId) {
        this.actionUserId = actionUserId;
    }

    public String getIP() {
        return this.IP;
    }

    public void setIP(String IP2) {
        this.IP = IP2;
    }

    public Integer getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(Integer moduleId) {
        this.moduleId = moduleId;
    }

    public Long getActionDepartmentId() {
        return this.actionDepartmentId;
    }

    public void setActionDepartmentId(Long actionDepartmentId) {
        this.actionDepartmentId = actionDepartmentId;
    }

    public String[] getParams() {
        ArrayList<String> params = new ArrayList<String>();
        this.collectParam(params, this.param0);
        this.collectParam(params, this.param1);
        this.collectParam(params, this.param2);
        this.collectParam(params, this.param3);
        this.collectParam(params, this.param4);
        this.collectParam(params, this.param5);
        return params.toArray(new String[params.size()]);
    }

    private void collectParam(List<String> params, String param) {
        if (param != null) {
            params.add(ResourceUtil.getString(param));
        } else {
            params.add("");
        }
    }

    public void setParams(String ... params) {
        if (params != null && params.length > 0) {
            String symbol = "...";
            switch (params.length) {
                case 6: {
                    this.param5 = Strings.getLimitLengthString(params[5], 1000, symbol);
                }
                case 5: {
                    this.param4 = Strings.getLimitLengthString(params[4], 330, symbol);
                }
                case 4: {
                    this.param3 = Strings.getLimitLengthString(params[3], 1000, symbol);
                }
                case 3: {
                    this.param2 = Strings.getLimitLengthString(params[2], 1000, symbol);
                }
                case 2: {
                    this.param1 = Strings.getLimitLengthString(params[1], 1000, symbol);
                }
                case 1: {
                    this.param0 = Strings.getLimitLengthString(params[0], 1000, symbol);
                }
            }
        }
    }

    public String getParam0() {
        return this.param0;
    }

    public String getParam1() {
        return this.param1;
    }

    public String getParam2() {
        return this.param2;
    }

    public String getParam3() {
        return this.param3;
    }

    public String getParam4() {
        return this.param4;
    }

    public String getParam5() {
        return this.param5;
    }

    public void setParam0(String param0) {
        this.param0 = param0;
    }

    public void setParam1(String param1) {
        this.param1 = param1;
    }

    public void setParam2(String param2) {
        this.param2 = param2;
    }

    public void setParam3(String param3) {
        this.param3 = param3;
    }

    public void setParam4(String param4) {
        this.param4 = param4;
    }

    public void setParam5(String param5) {
        this.param5 = param5;
    }

    public String getActionDesc() {
        if (this.actionDesc == null) {
            this.actionDesc = ResourceUtil.getString("appLog.action." + this.actionId, this.getParams());
        }
        return this.actionDesc;
    }

    public Integer getActionUserType() {
        return this.actionUserType;
    }

    public void setActionUserType(Integer actionUserType) {
        this.actionUserType = actionUserType;
    }

    private boolean inThis(int actionId) {
        if (actionId == AppLogAction.Organization_UpdateGroupAccount.getKey()) {
            return true;
        }
        if (actionId == AppLogAction.Organization_UpdateGroupAdminPassword.getKey()) {
            return true;
        }
        if (actionId == AppLogAction.Organization_GroupAdminAddCntPost.getKey()) {
            return true;
        }
        if (actionId == AppLogAction.Organization_GroupAdminUpdateCntPost.getKey()) {
            return true;
        }
        return actionId == AppLogAction.Organization_GroupAdminDeleteCntPost.getKey();
    }

    public String getActionType() {
        if (this.actionType == null) {
            this.actionType = (Boolean)SysFlag.sys_isGovVer.getFlag() != false && this.inThis(this.actionId) ? this.getString("appLog.actionType." + this.actionId + ".GOV") : this.getString("appLog.actionType." + this.actionId);
        }
        return this.actionType;
    }

    private String getString(String key) {
        String value = ResourceBundleUtil.getString(resource_common_baseName, key, new Object[0]);
        if (key.equals(value)) {
            value = ResourceUtil.getString(key);
        }
        return value;
    }

    public String getModuleName() {
        if (this.moduleName == null) {
            this.moduleName = this.moduleId == 400 ? (((Boolean)SysFlag.sys_isA6Ver.getFlag()).booleanValue() ? this.getString("appLog.moduleName." + this.moduleId + ".A6") : this.getString("appLog.moduleName." + this.moduleId + SysFlag.EditionSuffix.getFlag())) : (this.moduleId == 6000 && (Boolean)SysFlag.sys_isA6Ver.getFlag() != false ? this.getString("appLog.moduleName." + this.moduleId + ".a6") : (this.moduleId == 600 ? this.getString("appLog.moduleName.new." + this.moduleId) : this.getString("appLog.moduleName." + this.moduleId)));
        }
        return this.moduleName;
    }
}

