/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.po.filemanager;

import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.filemanager.Constants;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.BasePO;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.common.security.SecurityHelper;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;

public class Attachment
extends BasePO
implements Serializable {
    private static final Log log = CtpLogFactory.getLog(Attachment.class);
    private static Hashtable<String, String> attIcon = new Hashtable();
    private static final long serialVersionUID = -4257997658760387293L;
    public static final String REF = "Attachment";
    public static final String PROP_TYPE = "type";
    public static final String PROP_FILE_URL = "fileUrl";
    public static final String PROP_MIME_TYPE = "mimeType";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_SIZE = "size";
    public static final String PROP_SUB_REFERENCE = "subReference";
    public static final String PROP_CATEGORY = "category";
    public static final String PROP_CREATEDATE = "createdate";
    public static final String PROP_FILENAME = "filename";
    public static final String PROP_REFERENCE = "reference";
    public static final String PROP_ID = "id";
    public static final String Prop_GenesisId = "genesisId";
    public static final String PROP_SORT = "sort";
    private Long reference = 1L;
    private Long subReference = 1L;
    private Integer category;
    private Integer type;
    private String filename;
    private String mimeType;
    private Date createdate;
    private Long size;
    private String description;
    private Long fileUrl;
    private String extension = null;
    private String icon = null;
    private Long genesisId;
    private int sort;
    private String officeTransformEnable = "disable";
    private String v;

    public Attachment() {
    }

    public Attachment(Long id) {
        this.setId(id);
    }

    public Attachment(Long reference, Long subReference, Integer category, Integer type, String filename, String mimeType, Long fileUrl, Date createdate, Long size) {
        this.reference = reference;
        this.subReference = subReference;
        this.category = category;
        this.type = type;
        this.filename = filename;
        this.mimeType = mimeType;
        this.fileUrl = fileUrl;
        this.createdate = createdate;
        this.size = size;
    }

    public Attachment(Map<String, String> map) {
        String tmp;
        String string = tmp = map.get(PROP_REFERENCE) == null ? "" : String.valueOf(map.get(PROP_REFERENCE));
        if (Strings.isNotBlank(tmp)) {
            this.reference = Long.valueOf(tmp);
        }
        String string2 = tmp = map.get(PROP_SUB_REFERENCE) == null ? "" : String.valueOf(map.get(PROP_SUB_REFERENCE));
        if (Strings.isNotBlank(tmp)) {
            this.subReference = Long.valueOf(tmp);
        }
        tmp = map.get(PROP_CATEGORY) == null ? "" : String.valueOf(map.get(PROP_CATEGORY));
        if (Strings.isNotBlank(tmp = String.valueOf(tmp))) {
            this.category = Integer.valueOf(tmp);
        }
        tmp = map.get(PROP_TYPE) == null ? "" : String.valueOf(map.get(PROP_TYPE));
        if (Strings.isNotBlank(tmp = String.valueOf(tmp))) {
            this.type = Integer.valueOf(tmp);
        }
        this.filename = map.get(PROP_FILENAME);
        this.mimeType = map.get(PROP_MIME_TYPE);
        String string3 = tmp = map.get(PROP_FILE_URL) == null ? "" : String.valueOf(map.get(PROP_FILE_URL));
        if (Strings.isNotBlank(tmp)) {
            this.fileUrl = Long.valueOf(tmp);
        }
        if (Strings.isNotBlank(tmp = map.get(PROP_CREATEDATE))) {
            try {
                this.createdate = DateUtil.parse(tmp);
            }
            catch (ParseException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        tmp = map.get(PROP_SIZE) == null ? "" : String.valueOf(map.get(PROP_SIZE));
        if (Strings.isNotBlank(tmp = String.valueOf(tmp))) {
            this.size = Long.valueOf(tmp);
        }
    }

    public Attachment(V3XFile file) {
        this.category = file.getCategory();
        this.type = file.getType();
        this.filename = file.getFilename();
        this.mimeType = file.getMimeType();
        this.fileUrl = file.getId();
        this.createdate = file.getCreateDate();
        this.size = file.getSize();
    }

    public Attachment(V3XFile file, ApplicationCategoryEnum category, Constants.ATTACHMENT_TYPE type) {
        this.category = category.key();
        this.type = type.ordinal();
        this.filename = file.getFilename();
        this.mimeType = file.getMimeType();
        this.fileUrl = file.getId();
        this.createdate = file.getCreateDate();
        this.size = file.getSize();
    }

    public String getV() {
        if (this.v == null) {
            if (this.type == null) {
                if (this.fileUrl != null) {
                    this.v = SecurityHelper.digest(this.fileUrl);
                }
            } else {
                switch (this.type) {
                    case 0: 
                    case 3: 
                    case 5: {
                        if (this.fileUrl == null) break;
                        this.v = SecurityHelper.digest(this.fileUrl);
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (this.description == null || this.reference == null) break;
                        this.v = SecurityHelper.digest(this.description, this.reference);
                    }
                }
            }
        }
        return this.v;
    }

    public String getOfficeTransformEnable() {
        return this.officeTransformEnable;
    }

    public void setOfficeTransformEnable(String officeTransformEnable) {
        this.officeTransformEnable = officeTransformEnable;
    }

    public String getExtension() {
        if (this.extension == null) {
            int index = this.filename.lastIndexOf(".");
            this.extension = index == -1 ? "" : this.filename.substring(index + 1);
        }
        if (!Strings.isWord(this.extension)) {
            this.extension = "";
        }
        return this.extension.toLowerCase();
    }

    public String getIcon() {
        if (this.icon == null) {
            String suffix = null;
            if (this.type != null) {
                if (this.type.intValue() == Constants.ATTACHMENT_TYPE.FILE.ordinal() || this.type.intValue() == Constants.ATTACHMENT_TYPE.FormFILE.ordinal() || this.type.intValue() == Constants.ATTACHMENT_TYPE.NewsImage.ordinal()) {
                    suffix = this.getExtension();
                } else if (this.type.intValue() == Constants.ATTACHMENT_TYPE.FormDOCUMENT.ordinal() || this.type.intValue() == Constants.ATTACHMENT_TYPE.DOCUMENT.ordinal()) {
                    suffix = this.getMimeType();
                }
            }
            if (Strings.isNotBlank(suffix)) {
                this.icon = attIcon.get(suffix);
            }
            if (Strings.isBlank(this.icon)) {
                this.icon = attIcon.get("defaultICON");
            }
        }
        return this.icon;
    }

    public Long getReference() {
        return this.reference;
    }

    public void setReference(Long reference) {
        this.reference = reference;
    }

    public Long getSubReference() {
        return this.subReference;
    }

    public void setSubReference(Long subReference) {
        this.subReference = subReference;
    }

    public Integer getCategory() {
        return this.category;
    }

    public void setCategory(Integer category) {
        this.category = category;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Date getCreatedate() {
        return this.createdate;
    }

    public void setCreatedate(Date createdate) {
        this.createdate = createdate;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String getDescription() {
        if (this.description != null) {
            this.description = this.description.trim();
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(Long fileUrl) {
        this.fileUrl = fileUrl;
    }

    public Long getGenesisId() {
        return this.genesisId;
    }

    public void setGenesisId(Long genesisId) {
        this.genesisId = genesisId;
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    static {
        attIcon.put("zip", "zip.gif");
        attIcon.put("rar", "zip.gif");
        attIcon.put("gif", "gif.gif");
        attIcon.put("jpg", "jpg.gif");
        attIcon.put("jpeg", "jpg.gif");
        attIcon.put("bmp", "jpg.gif");
        attIcon.put("png", "jpg.gif");
        attIcon.put("txt", "txt.gif");
        attIcon.put("doc", "doc.gif");
        attIcon.put("docx", "doc.gif");
        attIcon.put("xls", "xls.gif");
        attIcon.put("xlsx", "xls.gif");
        attIcon.put("ppt", "ppt.gif");
        attIcon.put("pptx", "ppt.gif");
        attIcon.put("pdf", "pdf.gif");
        attIcon.put("xml", "xml.gif");
        attIcon.put("html", "html.gif");
        attIcon.put("htm", "html.gif");
        attIcon.put("xhtml", "html.gif");
        attIcon.put("et", "et.gif");
        attIcon.put("wps", "wps.gif");
        attIcon.put("mp3", "rm.gif");
        attIcon.put("rm", "rm.gif");
        attIcon.put("wav", "rm.gif");
        attIcon.put("wma", "rm.gif");
        attIcon.put("3gp", "rm.gif");
        attIcon.put("rmvb", "rm.gif");
        attIcon.put("avi", "rm.gif");
        attIcon.put("swf", "swf.gif");
        attIcon.put("exe", "exe.gif");
        attIcon.put("rep", "rep.gif");
        attIcon.put("collaboration", "collaboration.gif");
        attIcon.put("form", "form.gif");
        attIcon.put("km", "km.gif");
        attIcon.put("edoc", "edoc.gif");
        attIcon.put("plan", "plan.gif");
        attIcon.put("meeting", "meeting.gif");
        attIcon.put("bulletin", "bulletin.gif");
        attIcon.put("news", "news.gif");
        attIcon.put("bbs", "bbs.gif");
        attIcon.put("inquiry", "inquiry.gif");
        attIcon.put("defaultICON", "file.gif");
    }
}

