/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.quartz;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.quartz.QuartzHolder;
import com.seeyon.ctp.common.quartz.QuartzJob;
import com.seeyon.ctp.thread.ThreadInfoHolder;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public final class QuartzJobProxy
implements Job {
    private static final Log log = CtpLogFactory.getLog(QuartzJobProxy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ThreadInfoHolder.getInstance().initThread(Thread.currentThread());
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        HashMap<String, String> parameters = new HashMap<String, String>();
        String jobBeanId = null;
        Set keys = jobDataMap.keySet();
        if (keys != null) {
            for (String key : keys) {
                if (QuartzHolder.QUARTZ_JOB_CLASS_NAME.equals(key)) {
                    jobBeanId = (String)jobDataMap.get((Object)key);
                    continue;
                }
                parameters.put(key, (String)jobDataMap.get((Object)key));
            }
        }
        if (jobBeanId != null) {
            try {
                QuartzJob quartzJob = (QuartzJob)AppContext.getBean(jobBeanId);
                if (quartzJob != null) {
                    quartzJob.execute(parameters);
                } else {
                    QuartzHolder.deleteQuartzJob((String)parameters.get("_JobName"));
                }
            }
            catch (Exception e) {
                log.error((Object)("\u542f\u52a8Job[" + jobBeanId + "]\u5f02\u5e38"), (Throwable)e);
            }
            finally {
                AppContext.clearThreadContext();
            }
        }
        ThreadInfoHolder.getInstance().remove(Thread.currentThread());
    }
}

