/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.script;

import com.seeyon.ctp.common.script.CompiledScriptRunner;
import groovy.lang.GroovyClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Compilable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;

public class ScriptEvaluator {
    private static final ScriptEvaluator INSTANCE = new ScriptEvaluator();
    private Map cache = new ConcurrentHashMap();
    private ScriptEngine groovyEngine = new ScriptEngineManager().getEngineByName("groovy");
    private static Log LOG = LogFactory.getLog((String)"scriptcompile");
    private static String CATEGORY_SCRIPT = "class CtpCategory{public static Collection plus(Collection c,Object o){throw new Exception(\"\u96c6\u5408${c}\u4e0d\u80fd\u4e0e\u5bf9\u8c61${o}\u76f8\u52a0\")};public static Collection plus(Collection c,Collection o){throw new Exception(\"\u96c6\u5408${c}\u4e0d\u80fd\u4e0e\u96c6\u5408${o}\u76f8\u52a0\")};public static Collection minus(Collection c,Object o){throw new Exception(\"\u96c6\u5408${c}\u4e0d\u80fd\u4e0e\u5bf9\u8c61${o}\u76f8\u51cf\")};public static Collection minus(Collection c,Collection o){throw new Exception(\"\u96c6\u5408${c}\u4e0d\u80fd\u4e0e\u96c6\u5408${o}\u76f8\u51cf\")};public static Number plus(Number n,Collection c){throw new Exception(\"\u6570\u503c${n}\u4e0d\u80fd\u4e0e\u96c6\u5408${c}\u76f8\u52a0\")};public static Date plus(Date d,Integer n){throw new Exception(\"\u65e5\u671f${d}\u4e0d\u80fd\u4e0e\u6574\u6570${n}\u76f8\u52a0,\u8bf7\u4f7f\u7528\u65e5\u671f\u51fd\u6570\")};public static Date minus(Date d,Integer n){throw new Exception(\"\u65e5\u671f${d}\u4e0d\u80fd\u4e0e\u6574\u6570${n}\u76f8\u51cf,\u8bf7\u4f7f\u7528\u65e5\u671f\u51fd\u6570\")};public static Date plus(Date d,Double n){throw new Exception(\"\u65e5\u671f${d}\u4e0d\u80fd\u4e0e\u5c0f\u6570${n}\u76f8\u52a0,\u8bf7\u4f7f\u7528\u65e5\u671f\u51fd\u6570\")};public static Date minus(Date d,Double n){throw new Exception(\"\u65e5\u671f${d}\u4e0d\u80fd\u4e0e\u5c0f\u6570${n}\u76f8\u51cf,\u8bf7\u4f7f\u7528\u65e5\u671f\u51fd\u6570\")};public static Number plus(Date d1,Date d2){throw new Exception(\"\u65e5\u671f${d1}\u4e0d\u80fd\u76f4\u63a5\u4e0e\u65e5\u671f${d2}\u76f8\u52a0,\u8bf7\u4f7f\u7528\u65e5\u671f\u51fd\u6570\")};public static Number minus(Date d1,Date d2){throw new Exception(\"\u65e5\u671f${d1}\u4e0d\u80fd\u76f4\u63a5\u4e0e\u65e5\u671f${d2}\u76f8\u51cf,\u8bf7\u4f7f\u7528\u65e5\u671f\u51fd\u6570\")};private static BigDecimal toBigDecimal(Number d){if(d==null) return d;return new BigDecimal(d.toString())};public static Number multiply(Double a,Number b){toBigDecimal(a).multiply(toBigDecimal(b)).doubleValue()};public static Number multiply(Object a,Double b){a.multiply(toBigDecimal(b)).doubleValue()};public static Number div(Double a,Number b){toBigDecimal(a).div(toBigDecimal(b)).doubleValue()};public static Number div(BigDecimal a,Double b){a.div(toBigDecimal(b)).doubleValue()};};";

    private ScriptEvaluator() {
    }

    public static final ScriptEvaluator getInstance() {
        return INSTANCE;
    }

    public void clear() {
        this.cache.clear();
    }

    public Object eval(String scriptText, Map<String, Object> context) throws ScriptException {
        Object o = this.cache.get(scriptText);
        CompiledScriptRunner runner = null;
        if (o != null) {
            runner = (CompiledScriptRunner)o;
        } else {
            runner = new CompiledScriptRunner(this.groovyEngine, scriptText);
            this.cache.put(scriptText, runner);
        }
        long start = System.currentTimeMillis();
        Object result = runner.eval(context);
        long l = System.currentTimeMillis() - start;
        if (l > 30000L) {
            LOG.debug((Object)(l + ",\"" + scriptText + "\""));
        }
        return result;
    }

    public Object evalString(String scriptText, Map<String, Object> context) throws ScriptException {
        return this.eval("\"" + scriptText + "\"", context).toString();
    }

    public static String wrapCategory(String script) {
        return "use (com.seeyon.ctp.common.script.CtpGroovyCategory){" + script + "}";
    }

    public Map getScriptCache() {
        if (this.cache != null) {
            return this.cache;
        }
        return Collections.emptyMap();
    }

    public void compile(String script) {
        Compilable compEngine = (Compilable)((Object)this.groovyEngine);
        GroovyScriptEngineImpl impl = (GroovyScriptEngineImpl)this.groovyEngine;
        if (impl != null) {
            GroovyClassLoader classLoader = impl.getClassLoader();
            Class clazz = classLoader.parseClass(script, "CtpFormula");
        }
    }

    public void precompile(String script) {
        try {
            this.eval(script, new HashMap<String, Object>());
        }
        catch (ScriptException e) {
            LOG.error((Object)("groovy \u811a\u672c\u8ba1\u7b97\u9519\u8bef" + e.getMessage()));
        }
    }
}

