/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.script;

import com.seeyon.ctp.common.script.ScriptEvaluator;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ScriptRunnerTest {
    private static Map<String, Object> context;
    private String functions = "def \u52a0(a,b){a+b}\n def \u51cf = {x,y-> x-y}\n";

    @BeforeClass
    public static void initContext() {
        context = new HashMap<String, Object>();
        context.put("x", 1);
        context.put("y", 2);
        context.put("z", 3);
        context.put("str", "string");
    }

    @Test
    public void testEval() {
        ScriptEvaluator evaluator = ScriptEvaluator.getInstance();
        try {
            Assert.assertEquals((Object)evaluator.eval("x+y", context), (Object)3);
            Assert.assertEquals((Object)evaluator.eval("x+y", context), (Object)3);
            Assert.assertEquals((Object)evaluator.eval("str.length()", context), (Object)6);
            Assert.assertEquals((Object)evaluator.eval(this.functions + "\u52a0 x,y", context), (Object)3);
            Assert.assertEquals((Object)evaluator.eval(this.functions + "\u51cf(x,y)", context), (Object)-1);
            Assert.assertEquals((Object)evaluator.eval("import static com.seeyon.ctp.common.script.CommonFunctions.*\nadd(x,y)", context), (Object)3);
            Assert.assertEquals((Object)evaluator.eval("import static com.seeyon.ctp.common.script.CommonFunctions.*;\u52a0(x,y)", context), (Object)3);
            Assert.assertEquals((Object)evaluator.eval("import static com.seeyon.ctp.common.script.CommonFunctions.*;\u51cf(x,y)", context), (Object)-1);
        }
        catch (ScriptException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }
}

