/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.security;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.config.SystemConfig;
import com.seeyon.ctp.common.exceptions.InfrastructureException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class SecurityHelper
implements Serializable {
    private static final long serialVersionUID = -5342133189696901106L;
    private static final Log LOGGER = CtpLogFactory.getLog(SecurityHelper.class);
    private static final String ALGORITHM = "MD5";
    private static final Map<String, String> digestUrlMap = new HashMap<String, String>();
    private static SecureRandom sr = new SecureRandom();
    private static SystemConfig systemConfig;
    private static Boolean isCryptPassword;
    private static Invocable invocableEngine;

    public static SystemConfig getSystemConfig() {
        if (systemConfig == null) {
            systemConfig = (SystemConfig)AppContext.getBean("systemConfig");
        }
        return systemConfig;
    }

    public static String digest(Object ... digestPara) {
        StringBuilder digestStr = new StringBuilder();
        for (Object o : digestPara) {
            if (o == null) {
                throw new InfrastructureException("Digest\u6570\u636e\u53c2\u6570\u4e0d\u80fd\u4e3anull!");
            }
            digestStr.append(o);
        }
        MessageDigest digester = SecurityHelper.getCurrentSessionDigester();
        if (digester != null) {
            try {
                return SecurityHelper.bytes2Hex(((MessageDigest)digester.clone()).digest(digestStr.toString().getBytes()));
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
        }
        return String.valueOf(digestStr);
    }

    public static String func_digest(Object o1) {
        return SecurityHelper.digest(o1);
    }

    public static String func_digest(Object o1, Object o2) {
        return SecurityHelper.digest(o1, o2);
    }

    public static String func_digest(Object o1, Object o2, Object o3) {
        return SecurityHelper.digest(o1, o2, o3);
    }

    public static String func_digest(Object o1, Object o2, Object o3, Object o4) {
        return SecurityHelper.digest(o1, o2, o3, o4);
    }

    public static String func_digest(Object o1, Object o2, Object o3, Object o4, Object o5) {
        return SecurityHelper.digest(o1, o2, o3, o4, o5);
    }

    public static String func_digest(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        return SecurityHelper.digest(o1, o2, o3, o4, o5, o6);
    }

    public static boolean verify(String id, String digest) {
        if (id == null || digest == null) {
            return false;
        }
        return digest.equals(SecurityHelper.digest(id));
    }

    public static String getDigestUrlParam(String url) {
        return digestUrlMap.get(url);
    }

    public static void initSecurityUrlConfig() {
        Collection<String> pluginIds = SystemEnvironment.getPluginIds();
        SecurityHelper.loadSecurityUrlConfig("ctp");
        for (String pluginId : pluginIds) {
            SecurityHelper.loadSecurityUrlConfig(pluginId);
        }
    }

    private static void loadSecurityUrlConfig(String pluginId) {
        String digestUrlCfg = AppContext.getSystemProperty(pluginId + ".security.digesturl");
        if (digestUrlCfg != null) {
            String[] urls;
            for (String s : urls = digestUrlCfg.split("\\|")) {
                String[] cfg = s.split("\\ ");
                if (cfg.length == 3) {
                    digestUrlMap.put(cfg[0] + " " + cfg[1], cfg[2]);
                    continue;
                }
                if (cfg.length != 2) continue;
                digestUrlMap.put(cfg[0], cfg[1]);
            }
        }
    }

    public static int randomInt() {
        return sr.nextInt();
    }

    private static MessageDigest getCurrentSessionDigester() {
        MessageDigest digester = null;
        String seed = null;
        try {
            seed = (String)AppContext.getSessionContext("SESSION_CONTEXT_SECURITY_MESSAGEDIGEST_KEY");
            if (seed == null) {
                seed = String.valueOf(SecurityHelper.randomInt());
            }
            digester = MessageDigest.getInstance(ALGORITHM);
            digester.update(seed.getBytes());
            AppContext.putSessionContext("SESSION_CONTEXT_SECURITY_MESSAGEDIGEST_KEY", seed);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"md", (Throwable)e);
        }
        catch (InfrastructureException ie) {
            try {
                digester = MessageDigest.getInstance(ALGORITHM);
                digester.update(String.valueOf(SecurityHelper.randomInt()).getBytes());
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
        }
        return digester;
    }

    private static String bytes2Hex(byte[] bts) {
        String des = "";
        String tmp = null;
        for (int i = 0; i < bts.length; ++i) {
            tmp = Integer.toHexString(bts[i] & 0xFF);
            if (tmp.length() == 1) {
                des = des + "0";
            }
            des = des + tmp;
        }
        return des;
    }

    public static String getSessionContextSeed() {
        String seed = (String)AppContext.getSessionContext("SESSION_CONTEXT_SECURITY_SEED_KEY");
        if (seed == null) {
            seed = String.valueOf(SecurityHelper.randomInt());
            AppContext.putSessionContext("SESSION_CONTEXT_SECURITY_SEED_KEY", seed);
        }
        return seed;
    }

    public static String decrypt(String cryptData) {
        String seed = SecurityHelper.getSessionContextSeed();
        if (StringUtils.isBlank((CharSequence)cryptData)) {
            return null;
        }
        Exception e = null;
        for (int i = 0; i < 5; ++i) {
            try {
                return SecurityHelper._decrypt(cryptData, seed);
            }
            catch (Exception ex) {
                e = ex;
                continue;
            }
        }
        throw new InfrastructureException(e);
    }

    private static String _decrypt(String cryptData, String seed) throws Exception {
        return (String)invocableEngine.invokeFunction("decrypt", cryptData, seed);
    }

    public static void initScriptEngine(String appRoot) {
        ScriptEngineManager sem = new ScriptEngineManager();
        ScriptEngine se = sem.getEngineByName("javascript");
        try {
            invocableEngine = (Invocable)((Object)se);
            FileReader reader = new FileReader(new File(appRoot, "common/js/crypto.js".replace('/', File.separatorChar)));
            se.eval(reader);
            ((Reader)reader).close();
            se.eval("function decrypt(a,b){var v=CryptoJS.DES.decrypt(a,b);return ''+CryptoJS.enc.Utf8.stringify(v);}");
        }
        catch (Exception e) {
            throw new InfrastructureException(e);
        }
    }

    public static boolean isCryptPassword() {
        if (isCryptPassword == null) {
            isCryptPassword = "true".equals(AppContext.getSystemProperty("ctp.security.cryptLoginPassword"));
        }
        return isCryptPassword;
    }

    public static boolean isSM3CryptPassword() {
        return "enable".equals(SecurityHelper.getSystemConfig().get("gm_crypt_enable"));
    }

    static {
        isCryptPassword = null;
    }
}

