/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.security.sql.utils;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.util.UniqueList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.engine.query.NativeSQLQueryPlan;
import org.hibernate.impl.SessionFactoryObjectFactory;

public class HQLCheckUtil {
    public static final String ALL_HQL = "allHQLs";
    public static final String INJECT_HQL = "exHqls";

    public static List<String> getAllHQL() {
        return HQLCheckUtil.getHQL().get(ALL_HQL);
    }

    public static List<String> getInjectHQL() {
        return HQLCheckUtil.getHQL().get(INJECT_HQL);
    }

    public static Map<String, List<String>> getHQL() {
        Collection sessionFactory = SessionFactoryObjectFactory.getAll();
        Pattern pattern = Pattern.compile("([\u4e00-\u9fa5]+)|(\\d{8,})");
        UniqueList<String> allHQLs = new UniqueList<String>(2000);
        UniqueList<String> exHqls = new UniqueList<String>();
        for (Object o1 : sessionFactory) {
            SessionFactoryImplementor sf;
            Collection m;
            if (!(o1 instanceof SessionFactoryImplementor) || (m = (sf = (SessionFactoryImplementor)o1).getQueryPlanCache().getPlanCache().values()).isEmpty()) continue;
            HttpServletRequest request = AppContext.getRawRequest();
            if ("true".equalsIgnoreCase(request.getParameter("clear"))) {
                m.clear();
            }
            for (Object o : m) {
                Matcher m1;
                HQLQueryPlan p;
                String s = null;
                if (o instanceof HQLQueryPlan) {
                    p = (HQLQueryPlan)o;
                    s = p.getSourceQuery();
                    allHQLs.add(s);
                } else {
                    p = (NativeSQLQueryPlan)o;
                    s = p.getSourceQuery();
                    allHQLs.add(s);
                }
                if (!(m1 = pattern.matcher(s)).find()) continue;
                exHqls.add(s);
            }
            Iterator i = sf.getQueryPlanCache().getSqlParamMetadataCache();
            while (i.hasNext()) {
                String s = String.valueOf(i.next());
                Matcher m1 = pattern.matcher(s = StringUtils.substringBefore((String)s, (String)"=org.hibernate.engine.query.ParameterMetadata"));
                if (m1.find()) {
                    exHqls.add(s);
                }
                allHQLs.add(s);
            }
        }
        Collections.sort(allHQLs);
        Collections.sort(exHqls);
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>(2);
        resultMap.put(ALL_HQL, allHQLs);
        resultMap.put(INJECT_HQL, exHqls);
        return resultMap;
    }
}

