/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.spring;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.monitor.perfmon.PerfmonMisc;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.aop.framework.AopProxyUtils;

public class CTPRequestContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final Object handler;
    private final Class ultimateTargetClass;
    private String method = null;
    private String uri = null;
    private String url = null;
    private boolean isAjax = false;

    public CTPRequestContext(HttpServletRequest request, HttpServletResponse response, Object handler) throws BusinessException {
        this.request = request;
        this.response = response;
        this.handler = handler;
        this.ultimateTargetClass = handler != null ? AopProxyUtils.ultimateTargetClass((Object)handler) : null;
        this.isAjax = "/ajax.do".equals(this.getUri());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getMethodName() {
        if (this.method == null) {
            String m = this.request.getParameter("method");
            if (this.handler != null && "com.seeyon.v3x.common.controller.GenericController".equals(this.handler.getClass().getCanonicalName())) {
                m = this.request.getParameter("ViewPage");
            } else if (m == null) {
                m = "index";
            }
            this.method = m;
        }
        return this.method;
    }

    public Class getUltimateTargetClass() {
        return this.ultimateTargetClass;
    }

    public String getClassName() {
        if (this.isAjax) {
            String serviceName = this.getParameter("managerName");
            Object bean = AppContext.getBean(serviceName);
            if (bean == null) {
                return serviceName;
            }
            return PerfmonMisc.getAopProxySaneName(bean);
        }
        if (this.ultimateTargetClass != null) {
            return this.ultimateTargetClass.getName();
        }
        return null;
    }

    public String getUri() throws BusinessException {
        if (this.uri == null) {
            String uri = this.request.getRequestURI();
            if (uri.matches(".*?/{2,}.*?")) {
                throw new BusinessException("url\u683c\u5f0f\u9519\u8bef\u6709\u8d85\u8fc72\u4e2a\u4ee5\u4e0a\u7684'/'" + uri);
            }
            int idx = uri.indexOf(59);
            this.uri = uri = uri.substring(this.request.getContextPath().length(), idx == -1 ? uri.length() : idx);
        }
        return this.uri;
    }

    public String getUrl() throws BusinessException {
        if (this.url == null) {
            StringBuilder sb = new StringBuilder(this.getUri());
            String queryStr = this.request.getQueryString();
            if (queryStr != null) {
                sb.append("?").append(queryStr);
            } else {
                queryStr = "";
            }
            this.url = sb.toString();
        }
        return this.url;
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public boolean isAjax() throws BusinessException {
        return this.isAjax;
    }
}

