/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.test;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;

public class ReflectHelper {
    private static final Log log = CtpLogFactory.getLog(ReflectHelper.class);

    public static Object getObjectByConstructor(String className, Class[] intArgsClass, Object[] intArgs) throws NoSuchMethodException, Exception {
        Object returnObj = null;
        Class<?> classType = Class.forName(className);
        Constructor<?> constructor = classType.getDeclaredConstructor(intArgsClass);
        constructor.setAccessible(true);
        returnObj = constructor.newInstance(intArgs);
        return returnObj;
    }

    public static Object getObjectByConstructor(String className) throws NoSuchMethodException, Exception {
        Object returnObj = null;
        Class<?> classType = Class.forName(className);
        Constructor<?> constructor = classType.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        returnObj = constructor.newInstance(new Object[0]);
        return returnObj;
    }

    public static void setFieldValue(Object object, String fieldName, Object fieldValue) throws NoSuchFieldException, Exception {
        Class<?> classType = object.getClass();
        Field field = null;
        field = classType.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(object, fieldValue);
    }

    public static void setSupperFieldValue(Object object, String fieldName, Object fieldValue) throws NoSuchFieldException, Exception {
        Class<?> classType = object.getClass().getSuperclass();
        Field field = null;
        field = classType.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(object, fieldValue);
    }

    public static Object getFieldValue(Object object, String fieldName) throws NoSuchFieldException, Exception {
        Class<?> classType = object.getClass();
        Field field = null;
        Object fieldValue = null;
        field = classType.getDeclaredField(fieldName);
        field.setAccessible(true);
        fieldValue = field.get(object);
        return fieldValue;
    }

    public static Object getSupperFieldValue(Object object, String fieldName) {
        Class<?> classType = object.getClass().getSuperclass();
        Field field = null;
        Object fieldValue = null;
        try {
            field = classType.getDeclaredField(fieldName);
            field.setAccessible(true);
            fieldValue = field.get(object);
        }
        catch (NoSuchFieldException ex) {
            log.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
        }
        return fieldValue;
    }

    public static Object invokeMethod(Object object, String methodName, Class[] type, Object[] value) throws NoSuchMethodException, Exception {
        Class<?> classType = object.getClass();
        Method method = null;
        Object fieldValue = null;
        method = classType.getDeclaredMethod(methodName, type);
        method.setAccessible(true);
        fieldValue = method.invoke(object, value);
        return fieldValue;
    }

    public static Object invokeSupperMethod(Object object, String methodName, Class[] type, Class[] value) throws NoSuchMethodException, Exception {
        Class<?> classType = object.getClass().getSuperclass();
        Method method = null;
        Object fieldValue = null;
        method = classType.getDeclaredMethod(methodName, type);
        method.setAccessible(true);
        fieldValue = method.invoke(object, (Object[])value);
        return fieldValue;
    }

    public static Object invokeMethod(Object object, String methodName) throws NoSuchMethodException, Exception {
        Class<?> classType = object.getClass();
        Method method = null;
        Object fieldValue = null;
        method = classType.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        fieldValue = method.invoke(object, new Object[0]);
        return fieldValue;
    }

    public static Object invokeSupperMethod(Object object, String methodName) throws NoSuchMethodException, Exception {
        Class<?> classType = object.getClass().getSuperclass();
        Method method = null;
        Object fieldValue = null;
        method = classType.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        fieldValue = method.invoke(object, new Object[0]);
        return fieldValue;
    }
}

