/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.urlshortener;

import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.urlshortener.URLShortener;
import com.seeyon.ctp.util.Strings;
import com.seeyon.v3x.common.web.util.ResponseUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLShortenerServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(URLShortenerServlet.class);
    private static final long serialVersionUID = -973461330414768983L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResponseUtil.addResponseHeader(request, response);
        String shortUrl = request.getPathInfo();
        if (shortUrl.startsWith("/")) {
            shortUrl = shortUrl.substring(1);
        }
        try {
            String url = URLShortener.getUrl(shortUrl);
            if (Strings.isNotEmpty(url)) {
                response.sendRedirect("/" + url);
                return;
            }
        }
        catch (BusinessException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        response.sendError(404);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

