/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.common.web.filter;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.Strings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.DirectoryScanner;

public class JSPValve {
    private static Log LOG = LogFactory.getLog(JSPValve.class);
    private static String SECURITY_CONF_DIR = SystemEnvironment.getApplicationFolder() + File.separator + "WEB-INF" + File.separator + "cfgHome" + File.separator + "security";
    private static Map<String, Long> JSP_WHITELIST = new HashMap<String, Long>();

    private static void init() {
        String[] files;
        File dir = new File(SECURITY_CONF_DIR);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(dir);
        ds.setIncludes(new String[]{"jsp_whitelist_*"});
        ds.scan();
        for (String whitelistFiles : files = ds.getIncludedFiles()) {
            try {
                List rules = FileUtils.readLines((File)new File(dir, whitelistFiles), (String)"UTF-8");
                for (String rule : rules) {
                    File f;
                    if ((rule = rule.trim()).startsWith("#") || !(f = new File(SystemEnvironment.getApplicationFolder(), rule)).exists()) continue;
                    JSP_WHITELIST.put(rule, f.lastModified());
                }
            }
            catch (IOException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public static void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest httpRequest;
        String uri;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && (uri = (httpRequest = (HttpServletRequest)request).getRequestURI()).toLowerCase().endsWith(".jsp")) {
            Long timestamp = JSP_WHITELIST.get(uri = uri.substring(8));
            Long lastModified = timestamp;
            if (lastModified == null) {
                ((HttpServletResponse)response).sendError(404);
                JSPValve.onError("\u62e6\u622a\u5230\u53ef\u7591\u7684jsp\u8bbf\u95ee\uff1a" + uri + " \u6765\u81ea " + Strings.getRemoteAddr(httpRequest));
            } else {
                File f = new File(SystemEnvironment.getApplicationFolder(), uri);
                if (f.exists() && FileUtil.inDirectory(f, new File(SystemEnvironment.getApplicationFolder())) && f.lastModified() != lastModified.longValue()) {
                    ((HttpServletResponse)response).sendError(401);
                    JSPValve.onError("jsp\u5728\u8fd0\u884c\u671f\u88ab\u7be1\u6539\uff1a" + uri + " \u62d2\u7edd\u8bbf\u95ee\u3002 ");
                }
            }
        }
    }

    private static void onError(String msg) throws ServletException {
        LOG.error((Object)msg);
        throw new ServletException(msg);
    }

    static {
        JSPValve.init();
    }
}

