/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.config;

import com.seeyon.client.SpringRestClient;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.config.util.DataUtil;
import com.seeyon.ctp.util.ServerDetector;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigDeliver {
    private static final Log LOG = LogFactory.getLog(ConfigDeliver.class);
    private final SpringRestClient client;
    private Set<String> filters;

    public ConfigDeliver(String url) {
        this.client = new SpringRestClient(url);
    }

    public ConfigDeliver(String schema, String host, String port) {
        this.client = new SpringRestClient(schema, host, port);
    }

    public void push(String password) {
        Map<String, String> config = this.collect();
        try {
            String encryptData = DataUtil.encrypt(config, password);
            Map<String, String> result = this.send(encryptData);
            if (!"true".equals(result.get("success"))) {
                LOG.error((Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\uff1a" + config + "  " + result));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("\u6570\u636e\u53d1\u9001\u5931\u8d25\uff1a" + config + "  " + e.getLocalizedMessage()), (Throwable)e);
        }
        LOG.debug((Object)("\u6570\u636e\u53d1\u9001\u6210\u529f\uff1a" + config));
    }

    private Map<String, String> send(final String encryptData) {
        StringBuilder path = new StringBuilder("config");
        Map result = this.client.post(path.toString(), new HashMap<String, String>(){
            {
                this.put("data", encryptData);
            }
        }, Map.class);
        return result;
    }

    private Map<String, String> collect() {
        SystemProperties properties = SystemProperties.getInstance();
        HashMap<String, String> config = new HashMap<String, String>();
        String host = "cdp.mongo.host";
        String port = "cdp.mongo.port";
        config.put(host, properties.getProperty(host));
        config.put(port, properties.getProperty(port));
        this.loadDataSourceConfig(config);
        return config;
    }

    private void loadDataSourceConfig(Map<String, String> ctpConfig) {
        if (ServerDetector.isTomcat()) {
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(SystemEnvironment.getBaseFolder() + "/conf/datasourceCtp.properties"));
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            this.copyProperty(prop, ctpConfig, "ctpDataSource.driverClassName");
            this.copyProperty(prop, ctpConfig, "ctpDataSource.url");
            this.copyProperty(prop, ctpConfig, "ctpDataSource.username");
            this.copyProperty(prop, ctpConfig, "ctpDataSource.password");
        }
    }

    private void copyProperty(Properties source, Map<String, String> target, String propertyName) {
        target.put(propertyName, source.getProperty(propertyName));
    }
}

