/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.datasource;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class CtpDynamicDataSource
extends AbstractRoutingDataSource {
    private static final Log LOGGER = CtpLogFactory.getLog(CtpDynamicDataSource.class);
    private static final ThreadLocal<Stack<String>> dataSourceKey = new ThreadLocal();

    protected Object determineCurrentLookupKey() {
        String dsKey;
        String string = dsKey = dataSourceKey.get() == null ? null : dataSourceKey.get().peek();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("thread[" + Thread.currentThread().getName() + "],determine dataSource[" + dsKey + "]"));
        }
        return dsKey;
    }

    public static void clearDataSourceKey() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("thread[" + Thread.currentThread().getName() + "],remove dataSource[" + dataSourceKey.get() + "]"));
        }
        if (dataSourceKey.get() == null) {
            return;
        }
        if (dataSourceKey.get().size() == 1) {
            dataSourceKey.remove();
        } else {
            dataSourceKey.get().pop();
        }
    }

    public static void clearAll() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("thread[" + Thread.currentThread().getName() + "],clear all dataSource"));
        }
        if (dataSourceKey.get() == null) {
            return;
        }
        dataSourceKey.remove();
    }

    public static void setDataSourceKey(String dataSource) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("thread[" + Thread.currentThread().getName() + "],set dataSource[" + dataSource + "]"));
        }
        if (dataSourceKey.get() == null) {
            dataSourceKey.set(new Stack());
        }
        dataSourceKey.get().push(dataSource);
    }

    public static String getDataSourceKey() {
        String dsKey = dataSourceKey.get() == null ? null : dataSourceKey.get().peek();
        return dsKey == null ? DataSourceName.MAIN.getSource() : dsKey;
    }
}

