/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.datasource.intercepter;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.task.AsynchronousBatchTask;
import com.seeyon.ctp.datasource.CtpDynamicDataSource;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import org.apache.commons.logging.Log;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="dataSourceInterceptor")
public class DataSourceInterceptor {
    private static final Log LOGGER = CtpLogFactory.getLog(DataSourceInterceptor.class);

    @Pointcut(value="(bean(*Manager*) || bean(*Listener)) && execution(public * com.seeyon.*..*.*(..)) && (@within(com.seeyon.ctp.datasource.annotation.ProcessInDataSource) || @annotation(com.seeyon.ctp.datasource.annotation.ProcessInDataSource))")
    public void managerMethod() {
    }

    @Around(value="managerMethod() && (@annotation(annotation) || @within(annotation))")
    public Object aroundMethod(ProceedingJoinPoint joinPoint, ProcessInDataSource annotation) throws Throwable {
        Object target = joinPoint.getTarget();
        if (target instanceof AsynchronousBatchTask) {
            ((AsynchronousBatchTask)target).setDataSourceName(annotation.name());
        }
        CtpDynamicDataSource.setDataSourceKey(annotation == null ? DataSourceName.BASE.getSource() : annotation.name().getSource());
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            CtpDynamicDataSource.clearDataSourceKey();
        }
    }
}

