/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.dubbo.filter;

import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcResult;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.SerializableUtil;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.springframework.session.web.http.CTPDelegatingFilterProxy;

public class DubboInvokerFilter
implements Filter {
    private static final Log logger = CtpLogFactory.getLog(DubboInvokerFilter.class);
    private static Result nillResult = new RpcResult();
    private static Set<String> requestFilterMethods = new HashSet<String>();
    private static Set<String> skipMockMethods = new HashSet<String>();

    public static synchronized void addNeedPassReqMethod(String methodName) {
        requestFilterMethods.add(methodName);
    }

    public static synchronized void addNeedPassReqMethods(Set<String> methodNames) {
        requestFilterMethods.addAll(methodNames);
    }

    public static Set<String> getRequestFilterMethods() {
        return requestFilterMethods;
    }

    public static boolean skipMockMethods(String methodName) {
        return skipMockMethods.contains(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) {
        Result result = null;
        boolean needClearRequest = false;
        try {
            boolean needMockRequest = requestFilterMethods.contains(invocation.getMethodName());
            needClearRequest = this.doSomethingPreInvoke(needMockRequest);
            result = invoker.invoke(invocation);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("remote invoke : " + invoker.getInterface().getName() + "." + invocation.getMethodName()));
            }
        }
        catch (Throwable t) {
            logger.error((Object)("dubbo\u8fdc\u7a0b\u8c03\u7528\u51fa\u9519, [" + t.getLocalizedMessage() + "]"));
            Result result2 = nillResult;
            return result2;
        }
        finally {
            this.doSomethingAfterInvoke(needClearRequest);
        }
        return result;
    }

    private boolean doSomethingPreInvoke(boolean mockRequest) {
        RpcContext.getContext().setAttachment("SESSION_CONTEXT_USERINFO_KEY", SerializableUtil.fstSerializeToString(AppContext.getCurrentUser()));
        HttpSession session = (HttpSession)AppContext.getThreadContext("THREAD_CONTEXT_SESSION_KEY");
        if (session != null) {
            CTPDelegatingFilterProxy.saveSession(session);
            RpcContext.getContext().setAttachment("THREAD_CONTEXT_SESSION_KEY", session.getId());
        }
        if (mockRequest) {
            return this.createRequest();
        }
        return false;
    }

    private boolean createRequest() {
        Enumeration pNames;
        HttpServletRequest request = AppContext.getRawRequest();
        if (request != null && (pNames = request.getAttributeNames()) != null && pNames.hasMoreElements()) {
            ConcurrentHashMap<String, Object> requestAttributesMap = new ConcurrentHashMap<String, Object>();
            while (pNames.hasMoreElements()) {
                String paramName = (String)pNames.nextElement();
                if (paramName.startsWith("org.") || paramName.startsWith("com.")) continue;
                requestAttributesMap.put(paramName, request.getAttribute(paramName));
            }
            requestAttributesMap.put("USER_CONTEXT_SERVER_PATH", request.getContextPath());
            RpcContext.getContext().setAttachment("THREAD_CONTEXT_REQUEST_KEY", SerializableUtil.fstSerializeToString(requestAttributesMap));
            return true;
        }
        return false;
    }

    private void doSomethingAfterInvoke(boolean clearRequest) {
        Map requestAttributesMap;
        if (!clearRequest) {
            return;
        }
        String attachment = RpcContext.getContext().getAttachment("THREAD_CONTEXT_REQUEST_KEY");
        Map map = requestAttributesMap = attachment == null ? null : (Map)SerializableUtil.fstDeserializeFromString(attachment);
        if (requestAttributesMap != null && requestAttributesMap.size() > 0) {
            HttpServletRequest request = AppContext.getRawRequest();
            for (Map.Entry entry : requestAttributesMap.entrySet()) {
                request.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
    }

    static {
        requestFilterMethods.add("handleContentView");
        requestFilterMethods.add("handleContentSaveOrUpdate");
        requestFilterMethods.add("transContentSaveOrUpdate");
        requestFilterMethods.add("projection");
        requestFilterMethods.add("doProjection");
        skipMockMethods.add("insertWorkflowTemplate");
    }
}

