/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.dubbo.filter;

import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.dubbo.DubboHttpSession;
import com.seeyon.ctp.dubbo.SeeyonRemoteRequest;
import com.seeyon.ctp.util.SerializableUtil;
import com.seeyon.ctp.util.Strings;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.session.web.http.CTPDelegatingFilterProxy;

public class DubboProviderFilter
implements Filter {
    private static final Log logger = CtpLogFactory.getLog(DubboProviderFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) {
        Result result;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(invocation.getMethodName() + " is invoking, and CurrentUser : " + RpcContext.getContext().getAttachment("SESSION_CONTEXT_USERINFO_KEY")));
        }
        try {
            this.doSomethingPreInvoke();
            result = invoker.invoke(invocation);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("remote invoke : " + invoker.getInterface().getName() + "." + invocation.getMethodName()));
            }
        }
        finally {
            this.doSomethingAfterInvoke();
        }
        return result;
    }

    private void doSomethingPreInvoke() {
        String attachment;
        AppContext.putThreadContext("SESSION_CONTEXT_USERINFO_KEY", SerializableUtil.fstDeserializeFromString(RpcContext.getContext().getAttachment("SESSION_CONTEXT_USERINFO_KEY")));
        String sessionId = RpcContext.getContext().getAttachment("THREAD_CONTEXT_SESSION_KEY");
        if (sessionId != null) {
            AppContext.putThreadContext("THREAD_CONTEXT_SESSION_KEY", CTPDelegatingFilterProxy.getSession(sessionId));
        }
        if (Strings.isEmpty(attachment = RpcContext.getContext().getAttachment("THREAD_CONTEXT_REQUEST_KEY"))) {
            return;
        }
        Map requestAttributesMap = (Map)SerializableUtil.fstDeserializeFromString(attachment);
        SeeyonRemoteRequest request = new SeeyonRemoteRequest(requestAttributesMap);
        AppContext.putThreadContext("THREAD_CONTEXT_REQUEST_KEY", request);
    }

    private void doSomethingAfterInvoke() {
        SeeyonRemoteRequest request;
        DubboHttpSession dhttpSession = (DubboHttpSession)AppContext.getThreadContext("THREAD_CONTEXT_SESSION_KEY");
        if (dhttpSession != null) {
            CTPDelegatingFilterProxy.saveSession(dhttpSession);
            AppContext.removeThreadContext("THREAD_CONTEXT_SESSION_KEY");
        }
        if ((request = (SeeyonRemoteRequest)AppContext.getRawRequest()) != null) {
            RpcContext.getContext().setAttachment("THREAD_CONTEXT_REQUEST_KEY", SerializableUtil.fstSerializeToString(request.getAttributeMap()));
            AppContext.removeThreadContext("THREAD_CONTEXT_REQUEST_KEY");
        }
        AppContext.removeThreadContext("THREAD_CONTEXT_JSONSTR_KEY");
        AppContext.removeThreadContext("THREAD_CONTEXT_JSONOBJ_KEY");
    }
}

