/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.event;

import com.seeyon.ctp.common.AbstractSystemInitializer;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.cache.redis.RedisHandler;
import com.seeyon.ctp.common.log.CapabilityLogger;
import com.seeyon.ctp.event.DistributedEventHandler;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.event.EventTriggerMode;
import com.seeyon.ctp.event.Listener;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.AnnotationAware;
import com.seeyon.ctp.util.annotation.AnnotationFactory;
import com.seeyon.ctp.util.annotation.ListenEvent;
import com.seeyon.ctp.util.annotation.MethodAnnotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;

public class ListenEventAnnotationAware
extends AbstractSystemInitializer
implements AnnotationAware {
    private static final Log logger = LogFactory.getLog(ListenEventAnnotationAware.class);
    private AnnotationFactory annotationFactory;

    @Override
    public void setAnnotationFactory(AnnotationFactory annotationFactory) {
        this.annotationFactory = annotationFactory;
    }

    @Override
    public void initialize() {
        Set<MethodAnnotation> methodAnnotation = this.annotationFactory.getAnnotationOfMethod(ListenEvent.class);
        if (methodAnnotation != null) {
            for (MethodAnnotation annotation : methodAnnotation) {
                if (!(annotation.getAnnotation() instanceof ListenEvent)) continue;
                try {
                    ListenEvent listenEvent = (ListenEvent)annotation.getAnnotation();
                    Class<? extends Event> event = listenEvent.event();
                    AnnotationReflectListener listener = new AnnotationReflectListener(annotation.getBeanName(), annotation.getMethodName(), event);
                    listener.async(listenEvent.async());
                    listener.setMode(listenEvent.mode());
                    listener.setOrder(listenEvent.order());
                    EventDispatcher.register(event, listener);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (SystemEnvironment.isDistributedMode()) {
                DistributedEventHandler deHandler = new DistributedEventHandler();
                RedisHandler.subSeeyonEvent(deHandler);
            }
        }
    }

    @Override
    public int getSortOrder() {
        return -9;
    }

    static class AnnotationReflectListener
    implements Listener {
        private final String beanName;
        private final String methodName;
        private final Class<? extends Event> event;
        private Method method;
        private Object bean;
        private boolean async = false;
        private boolean isEnabled = true;
        private EventTriggerMode mode;
        private int order;
        private boolean inited = false;

        public AnnotationReflectListener(String beanName, String methodName, Class<? extends Event> event) throws Exception {
            this.beanName = beanName;
            this.methodName = methodName;
            this.event = event;
        }

        private void init() throws SecurityException, NoSuchMethodException {
            Method m;
            if (this.inited) {
                return;
            }
            this.bean = AppContext.getBean(this.beanName);
            if (this.bean == null) {
                throw new UnsupportedOperationException("bean not found:" + this.beanName);
            }
            this.method = AopUtils.isJdkDynamicProxy((Object)this.bean) ? (m = AopUtils.getTargetClass((Object)this.bean).getMethod(this.methodName, this.event)) : this.bean.getClass().getMethod(this.methodName, this.event);
            this.inited = true;
        }

        @Override
        public void handle(Event event) {
            try {
                this.handle(event, true);
            }
            catch (Throwable e) {
                logger.error((Object)("\u4e8b\u4ef6\u76d1\u542c" + e.getLocalizedMessage()), e);
            }
        }

        @Override
        public void handle(Event event, boolean mute) throws Throwable {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6267\u884c\u76d1\u542c\uff1a" + this.beanName + "." + this.methodName));
            }
            long start = System.currentTimeMillis();
            try {
                this.init();
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
                this.dumpEvent(event);
                return;
            }
            try {
                if (AopUtils.isJdkDynamicProxy((Object)this.bean)) {
                    this.method.invoke(((Advised)this.bean).getTargetSource().getTarget(), event);
                } else {
                    this.method.invoke(this.bean, event);
                }
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                Throwable targetException = e.getTargetException();
                logger.error((Object)targetException.getMessage(), targetException);
                if (!mute) {
                    throw targetException;
                }
                this.dumpEvent(event);
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
                if (!mute) {
                    throw e;
                }
                this.dumpEvent(event);
            }
            if (CapabilityLogger.getInstance().isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(",");
                sb.append(event.getClass().getSimpleName());
                sb.append(",");
                sb.append(this.beanName);
                sb.append(".");
                sb.append(this.methodName);
                sb.append(",");
                sb.append(System.currentTimeMillis() - start);
                sb.append(",");
                sb.append(start - event.getTimestamp());
                CapabilityLogger.getInstance().debug(sb.toString());
            }
        }

        private void dumpEvent(Event event) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(this.beanName);
                sb.append(".");
                sb.append(this.methodName);
                sb.append(":");
                sb.append(event.getClass().getCanonicalName());
                logger.error((Object)Strings.getLimitLengthString(sb.toString(), 100, ""));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("AnnotationReflectListener:");
            s.append(this.beanName).append(".").append(this.methodName);
            s.append(",").append("async=").append(this.async()).append(",").append("isEnabled=").append(this.isEnabled());
            return s.toString();
        }

        @Override
        public boolean async() {
            return this.async;
        }

        @Override
        public boolean async(boolean async) {
            this.async = async;
            return this.async();
        }

        @Override
        public EventTriggerMode getMode() {
            return this.mode;
        }

        public void setMode(EventTriggerMode mode) {
            this.mode = mode;
        }

        @Override
        public boolean enabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this.isEnabled;
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }
    }
}

