/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.login;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.LoginResult;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.login.LoginToken;
import com.seeyon.ctp.login.LoginTokenManager;
import com.seeyon.ctp.login.LoginUserManager;
import com.seeyon.ctp.login.LoginUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginTokenUtil {
    protected static Log log = LogFactory.getLog(LoginTokenUtil.class);
    private static LoginTokenManager loginTokenManager;
    private static LoginUserManager loginUserManager;

    private static LoginUserManager getLoginUserManager() {
        if (loginUserManager == null) {
            loginUserManager = (LoginUserManager)AppContext.getBean("loginUserManager");
        }
        return loginUserManager;
    }

    private static LoginTokenManager getLoginTokenManager() {
        if (loginTokenManager == null) {
            loginTokenManager = (LoginTokenManager)AppContext.getBean("loginTokenManager");
        }
        return loginTokenManager;
    }

    public static LoginResult checkLoginToken(HttpServletRequest request) {
        String tokenId = request.getHeader("ltoken");
        if (tokenId != null && LoginTokenUtil.getLoginTokenManager() != null) {
            LoginToken ltoken = LoginTokenUtil.getLoginTokenManager().get(tokenId);
            if (ltoken != null) {
                String loginName = ltoken.getLoginName();
                LoginResult licenseCheck = LoginUtil.checkMobileLicense(loginName, ltoken.getLoginAccount());
                if (!LoginResult.OK.equals(licenseCheck)) {
                    return licenseCheck;
                }
                try {
                    User user = LoginTokenUtil.getLoginUserManager().create(loginName, ltoken.getUserAgentFrom(), request);
                    HttpSession session = request.getSession(false);
                    if (user != null && session != null) {
                        session.setAttribute("com.seeyon.current_user", (Object)user);
                    }
                    user.setLoginState(User.login_state_enum.ok);
                    LoginUtil.add2Online(user);
                    return LoginResult.OK;
                }
                catch (BusinessException e) {
                    return new LoginResult(1010, new String[0]);
                }
            }
            log.info((Object)"this Ltoken is Invalid !");
            return new LoginResult(5001, new String[0]);
        }
        return new LoginResult(1010, new String[0]);
    }
}

