/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.monitor.perfmon;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CapabilityLogger;
import com.seeyon.ctp.monitor.perfmon.PerfLogConfig;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;

public class PerfLogController {
    public Object perfmonLog(ProceedingJoinPoint pjp) throws Throwable {
        if (!PerfLogConfig.isRunning()) {
            return pjp.proceed();
        }
        long startTime = System.currentTimeMillis();
        Object retVal = pjp.proceed();
        startTime = System.currentTimeMillis() - startTime;
        if (startTime > (long)PerfLogConfig.getSlowlaunchControllerTime()) {
            Object[] objs;
            StringBuilder sb = new StringBuilder();
            sb.append(AppContext.currentUserLoginName()).append(",").append(pjp.getSignature().toShortString());
            sb.append(",").append(startTime);
            if (PerfLogConfig.isRecordControllerParam() && (objs = pjp.getArgs()) != null && objs[0] instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)objs[0];
                sb.append(",").append(request.getQueryString());
            }
            CapabilityLogger.getInstance().debug(sb.toString());
        }
        return retVal;
    }
}

