/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.services;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.services.ServiceException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;

public class CTPLocator {
    private final Log log = CtpLogFactory.getLog(CTPLocator.class);
    private static final CTPLocator INSTANCE = new CTPLocator();
    private Map<String, Object> classBeanMap = new ConcurrentHashMap<String, Object>();

    private CTPLocator() {
    }

    public static final CTPLocator getInstance() {
        return INSTANCE;
    }

    public <T> T lookup(Class<T> clazz) throws ServiceException {
        String key = clazz.getCanonicalName();
        if (this.classBeanMap.containsKey(key)) {
            return (T)this.classBeanMap.get(key);
        }
        Map<String, T> beans = AppContext.getBeansOfType(clazz);
        if (beans.size() == 0) {
            throw new ServiceException(0L, "\u5f53\u524dSpring\u4e0a\u4e0b\u6587\u627e\u4e0d\u5230\u63a5\u53e3" + key + "\u7684\u5b9e\u73b0\uff01");
        }
        Object bean2 = null;
        if (beans.size() > 1) {
            this.log.warn((Object)("\u63a5\u53e3\u6709\u591a\u4e2a\u5b9e\u73b0:" + key + "\uff0c\u53d6\u7b2c\u4e00\u4e2a\u63a5\u53e3\u7684\u76f4\u63a5\u5b9e\u73b0\u7c7b:"));
            for (Object bean2 : beans.values()) {
                this.log.warn(bean2);
                Class<?> beanClazz = bean2.getClass();
                if (beanClazz.getSuperclass() != null) continue;
                break;
            }
        } else {
            bean2 = beans.values().iterator().next();
        }
        this.classBeanMap.put(key, bean2);
        return (T)bean2;
    }
}

