/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.services.security;

import com.seeyon.ctp.cluster.ClusterConfigBean;
import com.seeyon.ctp.cluster.notification.NotificationManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.authenticate.domain.UserWrapper;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.init.MclclzUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.login.online.OnlineManager;
import com.seeyon.ctp.login.online.OnlineRecorder;
import com.seeyon.ctp.services.UserToken;
import com.seeyon.ctp.services.security.ServiceAuthenticator;
import com.seeyon.ctp.util.Strings;
import com.seeyon.oainterface.common.OAInterfaceException;
import com.seeyon.v3x.common.web.login.CurrentUser;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

public class ServiceManager {
    private ThreadLocal<String> currentToken = new ThreadLocal();
    private static CacheMap<String, String> sessionMap;
    private static CacheMap<String, UserToken> tokenMap;
    private static CacheMap<String, Long> tokenLifeCycleMap;
    private static Map<String, Long> pendings;
    private static final long SESSION_TIMEOUT = 900000L;
    private static final ServiceManager INSTANCE;
    private static OnlineManager onlineManager;
    private static Object isExceedMaxLoginNumberLock;
    private static Object o;
    private static int serverType;
    private static int m1Type;
    private static int vjoinPermissionType;
    private static final Log LOG;
    private static final Class<?> c1;

    private static void init() {
        if (o != null) {
            return;
        }
        o = MclclzUtil.invoke(c1, (String)"getInstance", (Class[])new Class[]{String.class}, null, (Object[])new Object[]{""});
        serverType = (Integer)MclclzUtil.invoke(c1, (String)"getserverType", null, (Object)o, null);
        m1Type = (Integer)MclclzUtil.invoke(c1, (String)"getm1Type", null, (Object)o, null);
        if (vjoinPermissionType == -1) {
            vjoinPermissionType = (Integer)MclclzUtil.invoke(c1, (String)"getVJoinPermissionType", null, (Object)o, null);
        }
    }

    private ServiceManager() {
        CacheAccessable factory = CacheFactory.getInstance(ServiceManager.class);
        sessionMap = factory.createMap("token");
        tokenMap = factory.createMap("tokenMap");
        tokenLifeCycleMap = factory.createMap("tokenLifeCycle");
        new TokenSyncThread().start();
    }

    public static final ServiceManager getInstance() {
        return INSTANCE;
    }

    private static OnlineManager getOnlineManager() {
        if (onlineManager == null) {
            onlineManager = (OnlineManager)AppContext.getBean("onlineManager");
        }
        return onlineManager;
    }

    public static boolean checkToken(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        if (sessionMap.get(token) != null) {
            ServiceManager.renew(token);
            return true;
        }
        if (NotificationManager.getInstance().isEnabled()) {
            try {
                Thread.sleep(500L);
                return ServiceManager.checkTokenDelay(token);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean checkTokenDelay(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        if (sessionMap.get(token) != null) {
            ServiceManager.renew(token);
            return true;
        }
        return false;
    }

    private static void renew(String token) {
        boolean isFromWeixin;
        User user;
        long now = System.currentTimeMillis();
        if (!ClusterConfigBean.getInstance().isClusterEnabled()) {
            tokenLifeCycleMap.put(token, now);
            ServiceManager.statistics(token, "renew update:", now);
        } else {
            Long created = tokenLifeCycleMap.get(token);
            if (created != null) {
                if (now - created > 900000L) {
                    tokenLifeCycleMap.put(token, now);
                    ServiceManager.statistics(token, "renew update:", now);
                    pendings.remove(token);
                } else {
                    pendings.put(token, now);
                    ServiceManager.statistics(token, "renew pending update:", now);
                }
            } else {
                tokenLifeCycleMap.put(token, now);
                ServiceManager.statistics(token, "renew create:", now);
            }
        }
        UserToken userToken = tokenMap.get(token);
        if (userToken != null && (user = userToken.getBindingUser()) != null && (isFromWeixin = Constants.login_useragent_from.weixin.name().equals(user.getUserAgentFrom()))) {
            ServiceManager.getOnlineManager().updateOnlineState(user);
        }
    }

    private static void statistics(String token, String message, long time) {
        if (LOG.isDebugEnabled()) {
            String date = time == 0L ? "" : new Date(time).toGMTString();
            LOG.debug((Object)("Token Lifecycle:" + token + " " + message + date));
        }
    }

    public void activeToken(String token) throws OAInterfaceException {
        this.currentToken.set(token);
        if (!ServiceManager.checkToken(token)) {
            throw new OAInterfaceException(12005, "Invalid token,please authenticate again.");
        }
    }

    public UserToken getToken(String userName, String password, User user) throws BusinessException {
        return this.getToken(userName, password, user, 0);
    }

    public UserToken getToken(String userName, String password, User user, int timeout) throws BusinessException {
        ServiceAuthenticator authenticator = (ServiceAuthenticator)AppContext.getBean("restUserManager");
        if (!authenticator.authenticate(userName, password)) {
            return this.getNullToken();
        }
        UserToken token = new UserToken(userName);
        if (user != null) {
            this.bind(user, token);
        }
        String tokenId = token.getId();
        sessionMap.put(tokenId, userName);
        tokenMap.put(tokenId, token);
        ServiceManager.renew(tokenId);
        return token;
    }

    @Deprecated
    public void bindToken(User user, String tokenId) throws BusinessException {
        UserToken token = tokenMap.get(tokenId);
        if (token.getBindingUser() != null) {
            throw new BusinessException("\u7981\u6b62\u4f7f\u7528\u540c\u4e00Token\u91cd\u590d\u7ed1\u5b9a\u7528\u6237\uff01");
        }
        if (token != null) {
            Object loc;
            this.bind(user, token);
            HttpSession session = (HttpSession)AppContext.getThreadContext("THREAD_CONTEXT_SESSION_KEY");
            if (session != null && (loc = AppContext.getSessionContext(SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME)) != null) {
                user.setLocale((Locale)loc);
            }
            tokenMap.notifyUpdate(tokenId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(User user, UserToken token) throws BusinessException {
        ServiceManager.init();
        Long loginAccountId = user.getLoginAccount();
        boolean isAdmin = user.isAdmin();
        boolean isFromWeixin = Constants.login_useragent_from.weixin.name().equals(user.getUserAgentFrom());
        if (isFromWeixin && !user.isVisitor()) {
            boolean isVJoinUser = user.getExternalType().equals(1);
            if (isVJoinUser && !isAdmin && vjoinPermissionType == 2) {
                Object object = isExceedMaxLoginNumberLock;
                synchronized (object) {
                    boolean isExceedMaxLoginNumber = OnlineRecorder.isExceedMaxLoginNumberVJoin();
                    if (isExceedMaxLoginNumber) {
                        throw new BusinessException("mail.read.alert.ExceedMaxLoginNumber", "");
                    }
                }
                ServiceManager.getOnlineManager().updateOnlineState(user);
            } else if (serverType == 2 && !isAdmin) {
                String serverPermissionType = (String)MclclzUtil.invoke(c1, (String)"getServerPermissionType", null, (Object)o, null);
                Object object = isExceedMaxLoginNumberLock;
                synchronized (object) {
                    boolean isOnline;
                    boolean isExceedMaxLoginNumber = OnlineRecorder.isExceedMaxLoginNumberServer();
                    if (isExceedMaxLoginNumber) {
                        boolean bl = isOnline = OnlineRecorder.getOnlineUser((String)user.getLoginName()) != null;
                        if (!isOnline) {
                            throw new BusinessException("mail.read.alert.ExceedMaxLoginNumber", "");
                        }
                    }
                    if ("2".equals(serverPermissionType) && OnlineRecorder.isExceedMaxLoginNumberServerInAccount((Long)loginAccountId)) {
                        boolean bl = isOnline = OnlineRecorder.getOnlineUser((String)user.getLoginName()) != null;
                        if (!isOnline) {
                            throw new BusinessException("login.label.ErrorCode.30");
                        }
                    }
                }
                ServiceManager.getOnlineManager().updateOnlineState(user);
            }
        }
        token.setBindingUser(user);
    }

    public void initCurrentUser(HttpServletRequest request, String tokenId) {
        User user;
        UserToken token = tokenMap.get(tokenId);
        if (token != null && (user = token.getBindingUser()) != null) {
            UserWrapper u = new UserWrapper(user);
            user.setRemoteAddr(Strings.getRemoteAddr(request));
            if (request.getHeader("Accept-Language") != null) {
                ((User)u).setLocale(request.getLocale());
            }
            AppContext.putThreadContext("SESSION_CONTEXT_USERINFO_KEY", u);
            CurrentUser.set(u);
            try {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    session.setAttribute("com.seeyon.current_user", (Object)u);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void logoutUser(String loginName) {
        for (String token : tokenMap.keySet()) {
            User user = tokenMap.get(token).getBindingUser();
            if (user == null || !loginName.equals(user.getLoginName())) continue;
            ServiceManager.removeToken(token);
            ServiceManager.statistics(token, "logout remove", 0L);
        }
    }

    private static void clearTimeoutToken() {
        for (String key : tokenLifeCycleMap.keySet()) {
            if (System.currentTimeMillis() - tokenLifeCycleMap.get(key) <= 900000L) continue;
            ServiceManager.removeToken(key);
            ServiceManager.statistics(key, "clearTimeoutToken remove", 0L);
        }
    }

    public UserToken getNullToken() {
        return UserToken.getNullToken();
    }

    public String getCurrentToken() {
        return this.currentToken.get();
    }

    public static Map<String, String> getTokenSessionMap() {
        return sessionMap.toMap();
    }

    public static void removeToken(String tokenId) {
        sessionMap.remove(tokenId);
        tokenMap.remove(tokenId);
        Long expired = tokenLifeCycleMap.remove(tokenId);
        pendings.remove(tokenId);
        ServiceManager.statistics(tokenId, "removeToken", expired);
    }

    static {
        pendings = new ConcurrentHashMap<String, Long>();
        INSTANCE = new ServiceManager();
        isExceedMaxLoginNumberLock = new Object();
        o = null;
        vjoinPermissionType = -1;
        LOG = CtpLogFactory.getLog(ServiceManager.class);
        c1 = MclclzUtil.ioiekc((String)"com.seeyon.ctp.permission.bo.LicensePerInfo");
    }

    class TokenSyncThread
    extends Thread {
        boolean running = true;

        public TokenSyncThread() {
            super.setName("TokenSyncThread");
        }

        @Override
        public synchronized void start() {
            super.start();
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    long now = System.currentTimeMillis();
                    Map pendingMap = pendings;
                    pendings = new ConcurrentHashMap();
                    for (String token : pendingMap.keySet()) {
                        Long created = (Long)tokenLifeCycleMap.get(token);
                        if (created == null || now - created <= 830000L) continue;
                        tokenLifeCycleMap.put(token, (Serializable)pendingMap.get(token));
                        ServiceManager.statistics(token, "TokenSyncThread update:", now);
                    }
                    pendingMap.clear();
                    ServiceManager.clearTimeoutToken();
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }
}

