/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.session;

import com.seeyon.ctp.session.CTPSessionRepository;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.springframework.session.ExpiringSession;
import org.springframework.session.Session;

class MapSession
implements ExpiringSession,
Serializable {
    public static final int DEFAULT_MAX_INACTIVE_INTERVAL_SECONDS = 1800;
    private String id;
    private Map<String, Object> sessionAttrs = new HashMap<String, Object>();
    private long creationTime;
    private long lastAccessedTime = this.creationTime = System.currentTimeMillis();
    private int maxInactiveInterval = 1800;
    private static final long serialVersionUID = 7160779239673823561L;

    public MapSession() {
        this(UUID.randomUUID().toString());
    }

    public MapSession(String id) {
        this.id = id;
    }

    public MapSession(ExpiringSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session cannot be null");
        }
        this.id = session.getId();
        this.sessionAttrs = new HashMap<String, Object>(session.getAttributeNames().size());
        for (String attrName : session.getAttributeNames()) {
            Object attrValue = session.getAttribute(attrName);
            this.sessionAttrs.put(attrName, attrValue);
        }
        this.lastAccessedTime = session.getLastAccessedTime();
        this.creationTime = session.getCreationTime();
        this.maxInactiveInterval = session.getMaxInactiveIntervalInSeconds();
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void setMaxInactiveIntervalInSeconds(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveIntervalInSeconds() {
        return this.maxInactiveInterval;
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    boolean isExpired(long now) {
        if (this.maxInactiveInterval < 0) {
            return false;
        }
        return now - TimeUnit.SECONDS.toMillis(this.maxInactiveInterval) >= this.lastAccessedTime;
    }

    public <T> T getAttribute(String attributeName) {
        Object value;
        if (!CTPSessionRepository.SESSION_KEY_WHITE_LIST.contains(attributeName) && (value = CTPSessionRepository.sessions.get(attributeName, this.getId())) != null) {
            return (T)value;
        }
        Object object = this.sessionAttrs.get(attributeName);
        return (T)object;
    }

    public Set<String> getAttributeNames() {
        return this.sessionAttrs.keySet();
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        if (!CTPSessionRepository.SESSION_KEY_WHITE_LIST.contains(attributeName)) {
            CTPSessionRepository.sessions.put(attributeName, attributeValue, this.getId());
            return;
        }
        if (attributeValue == null) {
            this.removeAttribute(attributeName);
        } else {
            this.sessionAttrs.put(attributeName, attributeValue);
        }
    }

    public void removeAttribute(String attributeName) {
        if (!CTPSessionRepository.SESSION_KEY_WHITE_LIST.contains(attributeName)) {
            CTPSessionRepository.sessions.remove(attributeName, this.getId());
            return;
        }
        this.sessionAttrs.remove(attributeName);
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        return obj instanceof Session && this.id.equals(((Session)obj).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

