/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.thread.single;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.thread.single.SingleThread;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;

public class SingleThreadPool {
    private static final Log LOGGER = CtpLogFactory.getLog(SingleThreadPool.class);
    private ConcurrentHashMap<String, SingleThread> pool = new ConcurrentHashMap();
    private static SingleThreadPool instance = new SingleThreadPool();

    public static SingleThreadPool getInstnace() {
        return instance;
    }

    private SingleThreadPool() {
    }

    public static long getThreadId(String clazzName) {
        SingleThread t = SingleThreadPool.instance.pool.get(clazzName);
        return t.getStamp();
    }

    public List<SingleThread> getThreadList() {
        ArrayList<SingleThread> result = new ArrayList<SingleThread>();
        Set<Map.Entry<String, SingleThread>> threads = this.pool.entrySet();
        for (Map.Entry<String, SingleThread> t : threads) {
            result.add(t.getValue());
        }
        return result;
    }

    public static void addThread(SingleThread worker) {
        Thread thread;
        String clazzName = worker.clazzName;
        SingleThread t = SingleThreadPool.instance.pool.get(clazzName);
        worker.thread = thread = new Thread(worker);
        SingleThreadPool.instance.pool.put(clazzName, worker);
        if (t != null && t.thread != null) {
            LOGGER.info((Object)("\u5f00\u59cb\u7ec8\u6b62\u539f\u6765\u7684\u7ebf\u7a0b\uff1a" + clazzName + "\uff1bstamp=" + t.getStamp()));
            t.thread.interrupt();
        }
        thread.start();
        LOGGER.info((Object)("\u542f\u52a8\u65b0\u7684\u7ebf\u7a0b\uff1a" + clazzName + "\uff1bstamp=" + worker.getStamp()));
    }

    public static void stopThread() {
        Set<Map.Entry<String, SingleThread>> threadPool = SingleThreadPool.instance.pool.entrySet();
        for (Map.Entry<String, SingleThread> it : threadPool) {
            SingleThread worker = it.getValue();
            try {
                if (worker == null || worker.thread == null) continue;
                worker.isExit = true;
                if (worker.thread.getId() != Thread.currentThread().getId()) {
                    LOGGER.info((Object)("\u5f00\u59cb\u5173\u95ed\u7ebf\u7a0b:" + worker.clazzName));
                    Thread t = worker.thread;
                    t.interrupt();
                    t.join(3000L);
                    continue;
                }
                worker.thread = null;
            }
            catch (Throwable e) {
                LOGGER.error((Object)("\u5173\u95ed\u7ebf\u7a0b[" + worker.clazzName + "]\u65f6\u9519\u8bef"), e);
            }
        }
    }
}

