/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.tool;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CheckstyleReportAnalyzer {
    public static Report parse(String filename) {
        Report report = new Report();
        SAXReader saxReader = new SAXReader();
        try {
            File file = new File(filename);
            report.setName(file.getName().split("_")[1]);
            Document document = saxReader.read(file);
            Element root = document.getRootElement();
            int fileCount = 0;
            int errorCount = 0;
            int warningCount = 0;
            for (Object o : root.elements("file")) {
                Element eFile = (Element)o;
                for (Object oError : eFile.elements()) {
                    Element eError = (Element)oError;
                    String severity = eError.attributeValue("severity");
                    if ("warning".equals(severity)) {
                        ++warningCount;
                    }
                    if (!"error".equals(severity)) continue;
                    ++errorCount;
                    report.addError(eError.attributeValue("source"));
                }
                ++fileCount;
            }
            report.setFileCount(fileCount / 2);
            report.setErrorCount(errorCount);
            report.setWarningCount(warningCount);
            return report;
        }
        catch (DocumentException e) {
            return report;
        }
    }

    static class Report {
        private List<String> errors = new ArrayList<String>();
        private String name;
        private int errorCount = 0;
        private int fileCount = 0;
        private int warningCount = 0;

        Report() {
        }

        public String toString() {
            return this.name + "\t" + this.fileCount + "\t" + this.errorCount + "\t" + this.warningCount;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void addError(String msg) {
            this.errors.add(msg);
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public void setErrorCount(int errorCount) {
            this.errorCount = errorCount;
        }

        public int getFileCount() {
            return this.fileCount;
        }

        public void setFileCount(int fileCount) {
            this.fileCount = fileCount;
        }

        public int getWarningCount() {
            return this.warningCount;
        }

        public void setWarningCount(int warningCount) {
            this.warningCount = warningCount;
        }
    }
}

