/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.cglib.CglibCopier;
import com.seeyon.ctp.common.log.CtpLogFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.springframework.util.Assert;

public class BeanUtils {
    private static final Log log = CtpLogFactory.getLog(BeanUtils.class);

    public static void convert(Object dest, Object orig) {
        try {
            if (orig != null) {
                PropertyUtils.copyProperties((Object)dest, (Object)orig);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u7c7b\u578b\u8f6c\u6362\uff1a", (Throwable)e);
        }
    }

    public static List<? extends Object> converts(Class<?> destClass, Collection<? extends Object> origCollection) {
        ArrayList result = new ArrayList();
        if (CollectionUtils.isNotEmpty(origCollection)) {
            try {
                for (Object object : origCollection) {
                    Object dest = destClass.newInstance();
                    PropertyUtils.copyProperties(dest, (Object)object);
                    result.add(dest);
                }
            }
            catch (Exception e) {
                log.error((Object)"\u7c7b\u578b\u8f6c\u6362\uff1a", (Throwable)e);
            }
        }
        return result;
    }

    public static Object getPrivateProperty(Object object, String propertyName) throws IllegalAccessException, NoSuchFieldException {
        Assert.notNull((Object)object);
        Assert.hasText((String)propertyName);
        Field field = object.getClass().getDeclaredField(propertyName);
        field.setAccessible(true);
        return field.get(object);
    }

    public static void setPrivateProperty(Object object, String propertyName, Object newValue) throws IllegalAccessException, NoSuchFieldException {
        Assert.notNull((Object)object);
        Assert.hasText((String)propertyName);
        Field field = object.getClass().getDeclaredField(propertyName);
        field.setAccessible(true);
        field.set(object, newValue);
    }

    public static Object invokePrivateMethod(Object object, String methodName, Object[] params) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Assert.notNull((Object)object);
        Assert.hasText((String)methodName);
        Class[] types = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = params[i].getClass();
        }
        Method method = object.getClass().getDeclaredMethod(methodName, types);
        method.setAccessible(true);
        return method.invoke(object, params);
    }

    public static Object invokePrivateMethod(Object object, String methodName, Object param) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return BeanUtils.invokePrivateMethod(object, methodName, new Object[]{param});
    }

    public static <T> T create(Map<String, ? extends Object> map, Class<T> clazz) {
        try {
            T t = clazz.newInstance();
            BeanUtils.populate(map, t);
            return t;
        }
        catch (Exception e) {
            log.error((Object)"\u8f6c\u6362\u5bf9\u8c61\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    public static <T> T populate(Map<String, ? extends Object> map, T instance) {
        try {
            org.apache.commons.beanutils.BeanUtils.populate(instance, map);
        }
        catch (Exception e) {
            log.error((Object)"\u5bf9\u8c61\u503c\u62f7\u8d1d\u5931\u8d25", (Throwable)e);
        }
        return instance;
    }

    public static <T> T clone(T object) {
        T target = null;
        if (object != null) {
            if (org.springframework.beans.BeanUtils.isSimpleProperty(object.getClass())) {
                target = object;
            } else {
                try {
                    target = (T)object.getClass().newInstance();
                    CglibCopier.copy(object, target);
                }
                catch (Exception e) {
                    log.error((Object)"clone error", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
        return target;
    }

    public static <T, V> Map<T, V> cloneMap(Map<T, V> source, Map<T, V> target) {
        if (source == null) {
            return null;
        }
        for (Map.Entry<T, V> entry : source.entrySet()) {
            target.put(entry.getKey(), BeanUtils.cloneObj(entry.getValue()));
        }
        return target;
    }

    public static <T, V> Map<T, V> cloneHashMap(Map<T, V> source) {
        if (source == null) {
            return null;
        }
        return BeanUtils.cloneMap(source, new HashMap(source.size()));
    }

    public static <T, V> Map<T, V> cloneLinkedHashMap(Map<T, V> source) {
        if (source == null) {
            return null;
        }
        return BeanUtils.cloneMap(source, new LinkedHashMap(source.size()));
    }

    public static <V> List<V> cloneList(List<V> source, List<V> target) {
        if (source == null) {
            return null;
        }
        for (V v : source) {
            target.add(BeanUtils.cloneObj(v));
        }
        return target;
    }

    public static <V> List<V> cloneArrayList(List<V> source) {
        if (source == null) {
            return null;
        }
        ArrayList target = new ArrayList(source.size());
        return BeanUtils.cloneList(source, target);
    }

    public static <V> List<V> cloneLinkList(List<V> source) {
        if (source == null) {
            return null;
        }
        LinkedList target = new LinkedList();
        return BeanUtils.cloneList(source, target);
    }

    private static <T> T cloneObj(T object) {
        try {
            if (object instanceof Copyable) {
                return ((Copyable)object).doCopy();
            }
            if (object instanceof Cloneable) {
                try {
                    Method cloneMothed = object.getClass().getMethod("clone", new Class[0]);
                    return (T)cloneMothed.invoke(object, new Object[0]);
                }
                catch (NoSuchMethodException cloneMothed) {
                }
                catch (Exception e) {
                    log.error((Object)(object.getClass() + ".clone invoke exception "), (Throwable)e);
                }
            }
            return BeanUtils.clone(object);
        }
        catch (Exception e) {
            log.error((Object)"clone error", (Throwable)e);
            return null;
        }
    }

    public static interface Copyable<T> {
        public T doCopy();
    }
}

