/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;

public class CTPExecutor {
    public static <T> void execute(Collection<T> list, int threadCount, final Task<T> task) {
        ExecutorService exec = Executors.newCachedThreadPool();
        final Semaphore semp = new Semaphore(threadCount);
        for (final T o : list) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        semp.acquire();
                        task.execute(o);
                        semp.release();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            exec.execute(run);
        }
        exec.shutdown();
        while (!exec.isTerminated()) {
        }
    }

    public static interface Task<T> {
        public void execute(T var1);
    }
}

