/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.exceptions.InfrastructureException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.log4j.Logger;
import org.hibernate.lob.SerializableClob;

public class ClassUtil {
    private static final String conMethodFix = "To";
    private static final FastDateFormat sdf_yyyymmdd = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private static final FastDateFormat sdtf_yyyymmdd = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm");
    private static final String arrayFlag = "\\[\\]";
    private static final String arrayFlagChange = "_";
    private static final String getFlag = "get";
    private static final String setFlag = "set";
    private static final Log logger = CtpLogFactory.getLog(ClassUtil.class);

    protected static String StringBufferToString(StringBuffer data) {
        return data.toString();
    }

    protected static Long BigDecimalToLong(BigDecimal data) {
        return data.longValue();
    }

    protected static String IntegerToString(Integer data) {
        return data.toString();
    }

    protected static int IntegerToInteger(Integer data) {
        return data;
    }

    protected static BigDecimal StringToBigDecimal(String data) {
        if (data == null || "".equals(data.trim())) {
            return null;
        }
        return new BigDecimal(data);
    }

    protected static String DoubleToString(Double data) {
        return data.toString();
    }

    protected static String BooleanToString(Boolean data) {
        return data.toString();
    }

    protected static String FloatToString(Float data) {
        return data.toString();
    }

    protected static String TimestampToString(Timestamp data) {
        return sdtf_yyyymmdd.format((java.util.Date)data);
    }

    protected static BigInteger StringToBigInteger(String data) {
        if (data == null || "".equals(data.trim())) {
            return null;
        }
        return new BigInteger(data);
    }

    protected static String LongToString(Long data) {
        return "" + data;
    }

    protected static Integer LongToInteger(Long data) {
        return data.intValue();
    }

    protected static Integer BigDecimalToInteger(BigDecimal data) {
        return data.intValue();
    }

    protected static String BigDecimalToString(BigDecimal data) {
        return data.toString();
    }

    protected static Long StringToLong(String data) {
        if (data == null || "".equals(data.trim())) {
            return null;
        }
        return Long.parseLong(data);
    }

    protected static byte[] StringTobyte_(String data) {
        Base64 b64 = new Base64();
        return b64.decode(data.getBytes());
    }

    protected static String byte_ToString(byte[] data) {
        Base64 b64 = new Base64();
        return new String(b64.encode(data));
    }

    protected static Float StringToFloat(String data) {
        if (data == null || "".equals(data.trim())) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(data));
    }

    protected static String ShortToString(Short data) {
        return data.toString();
    }

    protected static Short StringToShort(String data) {
        if (data == null || "".equals(data.trim())) {
            return null;
        }
        return Short.parseShort(data);
    }

    protected static Boolean StringToBoolean(String data) {
        return "1".equals(data) || "true".equals(data);
    }

    protected static Double StringToDouble(String data) {
        if (data == null || "".equals(data.trim())) {
            return null;
        }
        return Double.parseDouble(data);
    }

    protected static java.util.Date StringToDate(String data) {
        try {
            if (data == null || "".equals(data.trim())) {
                return null;
            }
            return new java.util.Date(DateUtil.parse(data).getTime());
        }
        catch (ParseException e) {
            throw new InfrastructureException("\u65e5\u671f(Date)\u8f6c\u6362\u51fa\u9519:", e);
        }
    }

    protected static Enum StringToEnum(String data, Class cls) {
        Enum[] enums;
        if (data == null || "".equals(data.trim())) {
            return null;
        }
        for (Enum em : enums = (Enum[])cls.getEnumConstants()) {
            if (!data.equals(em.name())) continue;
            return em;
        }
        throw new InfrastructureException("\u679a\u4e3e\u8f6c\u6362\u51fa\u9519\uff08" + cls.getName() + "\uff09\uff0c\u65e0\u6cd5\u627e\u5230\u679a\u4e3e\u540d:" + data);
    }

    protected static Character StringToCharacter(String data) {
        return Character.valueOf(data.charAt(0));
    }

    protected static String CharacterToString(Character data) {
        return data.toString();
    }

    protected static Timestamp StringToTimestamp(String data) {
        try {
            if (data == null || "".equals(data.trim())) {
                return null;
            }
            return DateUtil.parseTimestamp(data);
        }
        catch (ParseException e) {
            throw new InfrastructureException("\u65f6\u95f4(Timestamp)\u8f6c\u6362\u51fa\u9519:", e);
        }
    }

    protected static Long BigIntegerToLong(BigInteger data) {
        return data.longValue();
    }

    protected static Integer BigIntegerToInteger(BigInteger data) {
        return data.intValue();
    }

    protected static Double BigIntegerToDouble(BigInteger data) {
        return data.doubleValue();
    }

    protected static Float BigIntegerToFloat(BigInteger data) {
        return Float.valueOf(data.floatValue());
    }

    protected static String BigIntegerToString(BigInteger data) {
        return data.toString();
    }

    protected static Float BigDecimalToFloat(BigDecimal data) {
        return Float.valueOf(data.floatValue());
    }

    protected static Integer StringToInteger(String data) {
        if (data == null || "".equals(data.trim())) {
            return null;
        }
        return Integer.parseInt(data);
    }

    protected static String DateToString(java.util.Date data) {
        return sdf_yyyymmdd.format(data);
    }

    protected static String DateToString(Date data) {
        return sdf_yyyymmdd.format((java.util.Date)data);
    }

    protected static String DateToString(java.util.Date data, String fix) {
        FastDateFormat tsdf = FastDateFormat.getInstance((String)fix);
        return tsdf.format(data);
    }

    protected static Double BigDecimalToDouble(BigDecimal data) {
        return data.doubleValue();
    }

    protected static Short BigDecimalToShort(BigDecimal data) {
        return data.shortValue();
    }

    public static Object CASEwithEmpty(Object orgData, Class tagClass) {
        if (orgData != null && String.class.isInstance(orgData) && StringUtil.checkNull((String)orgData)) {
            return null;
        }
        return ClassUtil.CASE(orgData, tagClass, null);
    }

    public static String toString(Object orgData) {
        String rt = (String)ClassUtil.CASE(orgData, String.class);
        if (rt == null) {
            return "null";
        }
        return rt;
    }

    public static Integer toInteger(Object orgData) {
        Integer rt = (Integer)ClassUtil.CASE(orgData, Integer.class);
        return rt;
    }

    public static Long toLong(Object orgData) {
        Long rt = (Long)ClassUtil.CASE(orgData, Long.class);
        return rt;
    }

    public static Double toDoublez(Object orgData) {
        Double rt = (Double)ClassUtil.CASE(orgData, Double.class);
        if (rt == null) {
            return 0.0;
        }
        return rt;
    }

    public static Integer toIntegerz(Object orgData) {
        Integer rt = (Integer)ClassUtil.CASE(orgData, Integer.class);
        if (rt == null) {
            return 0;
        }
        return rt;
    }

    public static Long toLongz(Object orgData) {
        Long rt = (Long)ClassUtil.CASE(orgData, Long.class);
        if (rt == null) {
            return 0L;
        }
        return rt;
    }

    protected static java.util.Date DateToDate(java.util.Date data) {
        return data;
    }

    protected static java.util.Date DateToDate(Date data) {
        return data;
    }

    public static Double toDouble(Object orgData) {
        Double rt = (Double)ClassUtil.CASE(orgData, Double.class);
        return rt;
    }

    protected static Long IntegerToLong(Integer data) {
        if (data == null) {
            return null;
        }
        return data.longValue();
    }

    public static Object CASE(Object orgData, Class tagClass, Object[] fixParm) {
        if (orgData != null && !tagClass.isAssignableFrom(orgData.getClass()) && orgData.getClass() != tagClass && !orgData.getClass().getSimpleName().equalsIgnoreCase(tagClass.getSimpleName())) {
            Class<?> orgClass = orgData.getClass();
            String methodName = orgClass.getSimpleName().replaceAll(arrayFlag, arrayFlagChange) + conMethodFix;
            if (tagClass.isEnum()) {
                methodName = methodName + "Enum";
                fixParm = fixParm == null ? new Object[1] : Arrays.copyOf(fixParm, fixParm.length + 1);
                fixParm[fixParm.length - 1] = tagClass;
            } else if (tagClass.isPrimitive()) {
                String cname = tagClass.getName();
                String postName = "int".equals(cname) ? "Integer" : ("char".equals(cname) ? "Character" : StringUtil.firstCharUp(cname));
                methodName = methodName + postName;
            } else {
                methodName = methodName + tagClass.getSimpleName().replaceAll(arrayFlag, arrayFlagChange);
            }
            try {
                Method method;
                Class[] types = null;
                Object[] datas = null;
                if (fixParm != null) {
                    types = new Class[fixParm.length + 1];
                    datas = new Object[fixParm.length + 1];
                    types[0] = orgClass;
                    datas[0] = orgData;
                    for (int i = 0; i < fixParm.length; ++i) {
                        Object curData = fixParm[i];
                        types[i + 1] = curData.getClass();
                        datas[i + 1] = curData;
                    }
                } else {
                    types = new Class[]{orgClass};
                    datas = new Object[]{orgData};
                }
                if ((method = ClassUtil.class.getDeclaredMethod(methodName, types)).getModifiers() != 2) {
                    return method.invoke(null, datas);
                }
            }
            catch (Throwable e) {
                String emsg = "";
                if (e instanceof InvocationTargetException) {
                    Throwable ee = ((InvocationTargetException)e).getTargetException();
                    emsg = ee.getMessage() + "," + ee.toString();
                } else {
                    emsg = e.getMessage() + "," + e.toString();
                }
                String msg = "\u6e90\u7c7bCLASS:" + orgClass.getName() + ",\u76ee\u6807\u7c7bCLASS:" + tagClass.getName() + ",\u6e90\u6570\u636eTOSTRING:" + orgData.toString() + ",\u9519\u8bef\u8be6\u7ec6\u4fe1\u606f:" + emsg;
                throw new InfrastructureException(msg, e);
            }
        }
        return orgData;
    }

    public static Object CASE(Object orgData, Class tagClass) {
        return ClassUtil.CASE(orgData, tagClass, null);
    }

    public static String getGetProMethodName(String proName) {
        return ClassUtil.getProMethodFix(proName, getFlag);
    }

    public static String getSetProMethodName(String proName) {
        return ClassUtil.getProMethodFix(proName, setFlag);
    }

    public static String getProMethodFix(String proName, String fix) {
        if (proName == null || proName.length() < 1) {
            return "";
        }
        return fix + proName.substring(0, 1).toUpperCase() + proName.substring(1);
    }

    public static Method[] getFirstNameMethods(Class type, String fixName, int parmCount) {
        return ClassUtil.getFirstNameMethodsL(type, fixName, parmCount).toArray(new Method[0]);
    }

    public static List<Method> getFirstNameMethodsL(Class type, String fixName, int parmCount) {
        Method[] methods;
        ArrayList<Method> rt = new ArrayList<Method>();
        for (Method method : methods = type.getMethods()) {
            if ("getClass".equals(method.getName()) || method.getName().indexOf(fixName) != 0 || method.getParameterTypes().length != parmCount) continue;
            rt.add(method);
        }
        return rt;
    }

    public static Class<?> converClassWithName(String clazz) {
        Class<?> rt = null;
        if (StringUtil.checkNull(clazz)) {
            return rt;
        }
        if ("char".equals(clazz)) {
            return Character.TYPE;
        }
        if ("int".equals(clazz)) {
            return Integer.TYPE;
        }
        if ("double".equals(clazz)) {
            return Double.TYPE;
        }
        if ("boolean".equals(clazz)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(clazz)) {
            return Byte.TYPE;
        }
        try {
            rt = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("\u67e5\u627e\u4e0d\u5230\u5bf9\u5e94\u7684CLASS,CLAZZ\u4e3a:" + clazz));
        }
        return rt;
    }

    public static Object findWithJndi(String path) {
        try {
            InitialContext initialContext = new InitialContext();
            return initialContext.lookup(path);
        }
        catch (NamingException e) {
            throw new InfrastructureException("\u6309\u5bf9\u5e94\u7684JNDI\u4e0d\u80fd\u627e\u5230\u5bf9\u5e94\u7684\u5bf9\u50cf.", e);
        }
    }

    public static InitialContext getInitialContext(Properties pop) {
        try {
            InitialContext initialContext = new InitialContext(pop);
            return initialContext;
        }
        catch (NamingException e) {
            throw new InfrastructureException("\u4e0d\u80fd\u521d\u59cb\u5316\u4e0a\u4e0b\u6587", e);
        }
    }

    public static String getBeanPro(String methodName, String fixStr, boolean isForceUCase) {
        if (!methodName.startsWith(fixStr)) {
            return null;
        }
        String rt = methodName.replaceFirst(fixStr, "");
        if (isForceUCase) {
            return rt.toUpperCase();
        }
        return rt.substring(0, 1).toLowerCase() + rt.substring(1);
    }

    public static Object findWithJndi(String path, InitialContext initialContext) {
        try {
            return initialContext.lookup(path);
        }
        catch (NamingException e) {
            throw new InfrastructureException("\u6309\u5bf9\u5e94\u7684JNDI\u548c\u5bf9\u5e94\u7684\u4e0a\u4e0b\u6587\u4e0d\u80fd\u627e\u5230\u5bf9\u5e94\u7684\u5bf9\u50cf.", e);
        }
    }

    public static final Object byteClone(Object src) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(src);
            out.close();
            ByteArrayInputStream bin = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bin);
            Object clone = in.readObject();
            in.close();
            return clone;
        }
        catch (ClassNotFoundException e) {
            throw new InfrastructureException(e.toString());
        }
        catch (StreamCorruptedException e) {
            throw new InfrastructureException(e.toString());
        }
        catch (IOException e) {
            throw new InfrastructureException(e.toString());
        }
    }

    public static void setObjectPro(Object data, String proName, Object value) {
        if (value == null) {
            return;
        }
        Class<?> type = data.getClass();
        if (Map.class.isAssignableFrom(type)) {
            ((Map)data).put(proName, value);
        } else {
            try {
                Method setMethod = ClassUtil.getMethodWithTypeNoException(type, proName, new Class[]{value.getClass()}, setFlag);
                if (setMethod == null) {
                    throw new InfrastructureException(type.getName() + "\u7c7b\u4e2d" + proName + "\u5c5e\u6027\u6ca1\u5bf9\u5e94\u7684get,set\u65b9\u6cd5");
                }
                setMethod.invoke(data, value);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public static void setObjectProWithCheck(Object data, String proName, Object value) {
        if (value == null) {
            return;
        }
        Class<?> type = data.getClass();
        if (Map.class.isAssignableFrom(type)) {
            ((Map)data).put(proName, value);
        } else {
            try {
                Method getMethod = ClassUtil.getMethodWithTypeNoException(type, proName, new Class[0], getFlag);
                if (getMethod == null) {
                    throw new InfrastructureException(type.getName() + "\u7c7b\uff0c\u6ca1\u627e\u5230" + proName + "\u5c5e\u6027\u7684get\u65b9\u6cd5");
                }
                Class<?> retType = getMethod.getReturnType();
                if ("void".equals(retType.getName())) {
                    throw new InfrastructureException(type.getName() + "\u4e2d" + getMethod.getName() + "\u65b9\u6cd5\u6ca1\u6709\u8fd4\u56de\u53c2\u6570.");
                }
                Method setMethod = ClassUtil.getMethodWithTypeNoException(type, proName, new Class[]{retType}, setFlag);
                if (setMethod == null) {
                    throw new InfrastructureException(type.getName() + "\u7c7b\u4e2d" + proName + "\u5c5e\u6027\u6ca1\u5bf9\u5e94\u7684get,set\u65b9\u6cd5");
                }
                setMethod.invoke(data, ClassUtil.CASE(value, retType));
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public static Object getObjectProIgnoreCase(Object data, String pro) {
        if (data == null) {
            throw new InfrastructureException("\u88ab\u53d6\u7684\u5bf9\u50cf\u4e3a\u7a7a\u3002");
        }
        Class<?> type = data.getClass();
        Object rt = null;
        if (data instanceof Map) {
            Map tmp = (Map)data;
            rt = tmp.get(pro);
            if (rt != null) {
                return rt;
            }
            for (Map.Entry item : tmp.entrySet()) {
                if (!pro.equalsIgnoreCase((String)item.getKey())) continue;
                return item.getValue();
            }
        } else {
            Method method = ClassUtil.getMethodWithTypeNoException(type, pro, new Class[0], getFlag);
            try {
                if (method != null) {
                    return method.invoke(data, null);
                }
                Method[] methods = type.getMethods();
                String tmn = getFlag + pro;
                for (Method item : methods) {
                    if (!item.getName().equalsIgnoreCase(tmn)) continue;
                    return item.invoke(data, null);
                }
            }
            catch (Exception e) {
                throw new InfrastructureException("\u4eceBEAN\u53d6\u503c\u51fa\u9519", e);
            }
        }
        return null;
    }

    public static Object getObjectPro(Object data, String pro) {
        if (data == null) {
            throw new InfrastructureException("\u88ab\u53d6\u7684\u5bf9\u50cf\u4e3a\u7a7a\u3002");
        }
        Class<?> type = data.getClass();
        if (data instanceof Map) {
            return ((Map)data).get(pro);
        }
        Method method = ClassUtil.getMethodWithTypeNoException(type, pro, new Class[0], getFlag);
        try {
            if (method != null) {
                return method.invoke(data, null);
            }
        }
        catch (Exception e) {
            throw new InfrastructureException("\u4eceBEAN\u53d6\u503c\u51fa\u9519", e);
        }
        return null;
    }

    public static boolean isBeanProMethod(Class beanClass, Method method) {
        if (beanClass == null) {
            throw new InfrastructureException("\u8981\u88ab\u68c0\u67e5\u7684BEAN CLASS\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (method == null) {
            throw new InfrastructureException("\u88ab\u68c0\u67e5\u7684\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String methodName = method.getName();
        char startFlag = methodName.charAt(0);
        if (methodName.length() < 3 || startFlag != 'g' && startFlag != 's') {
            return false;
        }
        try {
            if (startFlag == 'g') {
                beanClass.getMethod("s" + methodName.substring(1), method.getReturnType());
            } else {
                beanClass.getMethod("g" + methodName.substring(1), new Class[0]);
            }
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public static Method getMethodWithTypeNoException(Class type, String pro, Class[] valueTypes, String nameFix) {
        Method rt = null;
        if (!StringUtil.checkNull(pro)) {
            try {
                rt = type.getMethod(ClassUtil.getProMethodFix(pro, nameFix), valueTypes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rt;
    }

    public static String SerializableClobToString(SerializableClob data) {
        CharBuffer cb = CharBuffer.allocate(10);
        try {
            logger.info((Object)data.length());
        }
        catch (SQLException e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public static final void logDebug(Logger log, Object msg) {
        if (log.isDebugEnabled()) {
            log.debug(msg);
        }
    }
}

