/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.util.LightWeightEncoder;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Cookies {
    public static final int COOKIE_EXPIRES_One_day = 86400;
    public static final int COOKIE_EXPIRES_FOREVER = 31536000;

    public static void add(HttpServletResponse response, String name, String value, int Expires) {
        value = URLEncoder.encode(value);
        Cookie c = new Cookie(name, value);
        if (Expires >= 0) {
            c.setMaxAge(Expires);
        }
        c.setPath("/");
        response.addCookie(c);
    }

    public static void add(HttpServletResponse response, String name, String value, int Expires, boolean isEncode) {
        if (isEncode) {
            value = LightWeightEncoder.encodeString(value);
        }
        Cookies.add(response, name, value, Expires);
    }

    public static void add(HttpServletResponse response, String name, String value) {
        Cookies.add(response, name, value, -1);
    }

    public static void add(HttpServletResponse response, String name, String value, boolean isEncode) {
        if (isEncode) {
            value = LightWeightEncoder.encodeString(value);
        }
        Cookies.add(response, name, value, -1);
    }

    public static String get(HttpServletRequest request, String name) {
        Cookie[] c = request.getCookies();
        if (c != null) {
            for (int i = 0; i < c.length; ++i) {
                if (!c[i].getName().equals(name)) continue;
                String value = c[i].getValue();
                return URLDecoder.decode(value);
            }
        }
        return null;
    }

    public static String get(HttpServletRequest request, String name, boolean isEncode) {
        String v = Cookies.get(request, name);
        if (isEncode) {
            v = LightWeightEncoder.decodeString(v);
        }
        return v;
    }

    public static String get(HttpServletRequest request, String name, String defaultValue) {
        String v = Cookies.get(request, name);
        return v == null ? defaultValue : v;
    }

    public static String get(HttpServletRequest request, String name, String defaultValue, boolean isEncode) {
        String v = Cookies.get(request, name, defaultValue);
        if (isEncode) {
            v = LightWeightEncoder.decodeString(v);
        }
        return v;
    }

    public static void remove(HttpServletResponse response, String name) {
        Cookies.add(response, name, "", 0);
    }

    public static Enumeration<String> getNames(HttpServletRequest request) {
        ArrayList<String> names = new ArrayList<String>();
        Cookie[] c = request.getCookies();
        if (c != null) {
            for (Cookie cookie : c) {
                names.add(cookie.getName());
            }
        }
        return Collections.enumeration(names);
    }
}

