/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class ImageUtil {
    public static void resize1(String srcImageFilename, String destImageFilename, int maxWidth, int maxHeight) throws IOException {
        if (maxWidth < 1 || maxHeight < 1) {
            throw new IllegalArgumentException("maxWidth = " + maxWidth + ", maxHeight = " + maxHeight);
        }
        File inputFile = new File(srcImageFilename);
        if (!inputFile.exists() || !inputFile.isFile()) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u6587\u4ef6\uff1a" + srcImageFilename);
        }
        BufferedImage input = ImageIO.read(inputFile);
        int oWidth = input.getWidth();
        int oHeight = input.getHeight();
        double oWHRatio = (double)oWidth / (double)oHeight;
        double destWHRatio = (double)maxWidth / (double)maxHeight;
        int width = 0;
        int height = 0;
        if (oWHRatio >= destWHRatio) {
            if (oWidth > maxWidth) {
                width = maxWidth;
                height = (int)((double)maxWidth / oWHRatio);
            } else {
                width = oWidth;
                height = oHeight;
            }
        } else if (oHeight > maxHeight) {
            width = (int)(oWHRatio * (double)maxHeight);
            height = maxHeight;
        } else {
            width = oWidth;
            height = oHeight;
        }
        BufferedImage output = new BufferedImage(width, height, 1);
        Graphics2D g2d = output.createGraphics();
        g2d.setBackground(Color.WHITE);
        g2d.fillRect(0, 0, width, height);
        int dx = oWidth < width ? (width - oWidth) / 2 : 0;
        int dy = oHeight < height ? (height - oHeight) / 2 : 0;
        int dw = Math.min(oWidth, width);
        int dh = Math.min(oHeight, height);
        g2d.drawImage(input, dx, dy, dw, dh, null);
        File outputFile = new File(destImageFilename);
        ImageIO.write((RenderedImage)output, "jpg", outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resize(String srcImageFilename, String destImageFilename, int maxWidth, int maxHeight) throws IOException {
        if (maxWidth < 1 || maxHeight < 1) {
            throw new IllegalArgumentException("maxWidth = " + maxWidth + ", maxHeight = " + maxHeight);
        }
        File inputFile = new File(srcImageFilename);
        if (!inputFile.exists() || !inputFile.isFile()) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u6587\u4ef6\uff1a" + srcImageFilename);
        }
        BufferedImage input = ImageIO.read(inputFile);
        int oWidth = input.getWidth();
        int oHeight = input.getHeight();
        double oWHRatio = (double)oWidth / (double)oHeight;
        double destWHRatio = (double)maxWidth / (double)maxHeight;
        int width = 0;
        int height = 0;
        if (oWHRatio >= destWHRatio) {
            if (oWidth > maxWidth) {
                width = maxWidth;
                height = (int)((double)maxWidth / oWHRatio);
            } else {
                width = oWidth;
                height = oHeight;
            }
        } else if (oHeight > maxHeight) {
            width = (int)(oWHRatio * (double)maxHeight);
            height = maxHeight;
        } else {
            width = oWidth;
            height = oHeight;
        }
        com.aspose.imaging.Image image = com.aspose.imaging.Image.load((String)srcImageFilename);
        try {
            image.resizeWidthProportionally(width, 6);
            image.save(destImageFilename);
        }
        finally {
            image.close();
        }
    }

    public static byte[] cutAndCompress(File srcImage, String formatName, int containerWidth, int containerHeight, int clippedX, int clippedY, int clippedWidth, int clippedHeight) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] bytes = null;
        try {
            BufferedImage originalBi = ImageIO.read(srcImage);
            int srcWidth = originalBi.getWidth();
            int srcHeight = originalBi.getHeight();
            Image originalImage = originalBi.getScaledInstance(srcWidth, srcHeight, 1);
            int x1 = clippedX * srcWidth / containerWidth;
            int y1 = clippedY * srcHeight / containerHeight;
            int w1 = clippedWidth * srcWidth / containerWidth;
            int h1 = clippedHeight * srcHeight / containerHeight;
            CropImageFilter cropFilter = new CropImageFilter(x1, y1, w1, h1);
            Image imageAfterProcess = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(originalImage.getSource(), cropFilter));
            BufferedImage biAfterProcess = new BufferedImage(w1, h1, 1);
            Graphics g = biAfterProcess.getGraphics();
            g.drawImage(imageAfterProcess, 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)biAfterProcess, formatName, output);
            bytes = output.toByteArray();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return bytes;
    }

    public static byte[] cutAndCompress(String srcFilePath, String formatName, int containerWidth, int containerHeight, int clippedX, int clippedY, int clippedWidth, int clippedHeight) throws IOException {
        File srcImage = new File(srcFilePath);
        return ImageUtil.cutAndCompress(srcImage, formatName, containerWidth, containerHeight, clippedX, clippedY, clippedWidth, clippedHeight);
    }
}

