/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.config.PropertiesLoader;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.exceptions.InfrastructureException;
import com.seeyon.ctp.common.init.MclclzUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.plugin.PluginDefinition;
import com.seeyon.ctp.datasource.CtpDynamicDataSource;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMProxyDriver;
import com.seeyon.ctp.monitor.perf.jdbcmonitor.proxyobj.JMSQLOperation;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.impl.SessionImpl;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.support.CTPHibernateDaoSupport;

public final class JDBCAgent
implements Closeable {
    private static Log log = CtpLogFactory.getLog("org.hibernate.SQL.DBA");
    private Connection conn;
    private ResultSet queryResult;
    private Set stSet;
    private boolean raw = false;
    private int batchCount = 0;
    private int batchExcuted = 0;
    private PreparedStatement pstBatch;
    private boolean autoClose = false;
    private AtomicInteger concernNum = new AtomicInteger(0);
    private static final int RECORD_NUM_THRESHOLD = 500;
    private static Dialect dialect = null;
    private static Pattern paramRegPattern = Pattern.compile("(\\s+|[(=<>,])(:\\w+)");
    private static final Class<?> c1 = MclclzUtil.ioiekc((String)"com.seeyon.ctp.common.plugin.PluginSystemInit");

    public JDBCAgent(Connection conn) {
        this.conn = conn;
        this.raw = false;
        this.init();
    }

    @Deprecated
    public JDBCAgent() {
        this(false);
    }

    @Deprecated
    public JDBCAgent(boolean raw) {
        this(raw, false);
    }

    public JDBCAgent(boolean raw, boolean autoClose) {
        CTPHibernateDaoSupport dao;
        this.autoClose = autoClose;
        this.raw = raw;
        if (!raw && (dao = DBAgent.currentHibernateDaoSupport()) != null) {
            Session session = dao.currentSession();
            boolean isSessionTransactional = SessionFactoryUtils.isSessionTransactional((Session)session, (SessionFactory)session.getSessionFactory());
            if (!isSessionTransactional) {
                this.raw = true;
            }
            if (SystemEnvironment.isDistributedMode() && !SystemEnvironment.isBaseService() && CtpDynamicDataSource.getDataSourceKey().equals(DataSourceName.BASE.getSource())) {
                this.raw = true;
            }
        }
        if (this.raw) {
            try {
                this.conn = JDBCAgent.getRawConnection();
            }
            catch (SQLException e) {
                log.error((Object)"\u83b7\u53d6\u6570\u636e\u5e93\u539f\u751f\u8fde\u63a5\u5931\u8d25\uff01", (Throwable)e);
            }
        } else {
            this.conn = JDBCAgent.getConnection();
        }
        this.init();
    }

    public JDBCAgent(String dsName) {
        this.raw = true;
        try {
            this.conn = JDBCAgent.getRawConnection(dsName);
        }
        catch (SQLException e) {
            throw new InfrastructureException("Failed to get raw connection.", e);
        }
        this.init();
    }

    protected void init() {
        this.stSet = new HashSet();
        if (!this.raw) {
            ArrayList<JDBCAgent> dbaList = (ArrayList<JDBCAgent>)AppContext.getThreadContext("USER_CONTEXT_DBAGENTS_KEY");
            if (dbaList == null) {
                dbaList = new ArrayList<JDBCAgent>();
                AppContext.putThreadContext("USER_CONTEXT_DBAGENTS_KEY", dbaList);
            }
            dbaList.add(this);
        }
    }

    public int execute(String sqlString) throws BusinessException, SQLException {
        return this.execute(sqlString, new ArrayList());
    }

    public int execute(String sqlString, Object param) throws BusinessException, SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(param);
        return this.execute(sqlString, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String sqlString, List params) throws BusinessException, SQLException {
        int status;
        try {
            if (this.autoClose) {
                this.concernNum.incrementAndGet();
            }
            if (sqlString == null) {
                throw new BusinessException("There is not a executable sql.");
            }
            String sqlOpt = sqlString.trim().substring(0, 6).toLowerCase();
            if (log.isDebugEnabled()) {
                String tmpStr = sqlString;
                for (int i = 0; i < params.size(); ++i) {
                    Object param = params.get(i);
                    String newString = param == null ? "null" : "'" + param.toString() + "'";
                    tmpStr = StringUtil.replace(tmpStr, "?", newString, 1);
                }
                log.debug((Object)tmpStr);
            }
            status = sqlOpt.startsWith("select") || sqlOpt.startsWith("show") ? this.query(sqlString, params) : (sqlOpt.startsWith("update") || sqlOpt.startsWith("delete") || sqlOpt.startsWith("insert") ? this.update(sqlString, params) : (this.executeOther(sqlString, params) ? 1 : 0));
        }
        finally {
            if (this.autoClose) {
                this.close();
            }
        }
        return status;
    }

    private void setPreparedStatementObject(PreparedStatement pst, int index, Object obj) throws SQLException {
        Object paramObj = obj;
        if (obj != null && obj instanceof java.util.Date && !(obj instanceof Date)) {
            paramObj = new Timestamp(((java.util.Date)obj).getTime());
        }
        pst.setObject(index, paramObj);
    }

    private int query(String sql, List params) throws SQLException {
        Dialect dialect = JDBCAgent.getDialect();
        PreparedStatement pst = this.conn.prepareStatement(sql, dialect != null && dialect.supportsLimitOffset() ? 1003 : 1004, 1007);
        this.stSet.add(pst);
        Iterator inputParamsIte = params.iterator();
        int index = 1;
        while (inputParamsIte.hasNext()) {
            this.setPreparedStatementObject(pst, index++, inputParamsIte.next());
        }
        this.queryResult = pst.executeQuery();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int update(String sql, List params) throws SQLException {
        PreparedStatement pst = null;
        try {
            pst = this.conn.prepareStatement(sql);
            Iterator inputParamsIte = params.iterator();
            int index = 1;
            while (inputParamsIte.hasNext()) {
                this.setPreparedStatementObject(pst, index++, inputParamsIte.next());
            }
            int n = pst.executeUpdate();
            return n;
        }
        finally {
            if (pst != null) {
                pst.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeOther(String SQLString, List params) throws SQLException {
        PreparedStatement pst = null;
        try {
            pst = this.conn.prepareStatement(SQLString);
            Iterator inputParamsIte = params.iterator();
            int index = 1;
            while (inputParamsIte.hasNext()) {
                this.setPreparedStatementObject(pst, index, inputParamsIte.next());
                ++index;
            }
            boolean bl = pst.execute();
            return bl;
        }
        finally {
            if (pst != null) {
                pst.close();
            }
        }
    }

    public ResultSet getQueryResult() {
        return this.queryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeBatch(List batchedSql) throws BusinessException, SQLException {
        try {
            int n;
            block11: {
                if (this.autoClose) {
                    this.concernNum.incrementAndGet();
                }
                Statement stm = null;
                if (batchedSql == null || batchedSql.size() == 0) {
                    throw new BusinessException("No batched sql found.");
                }
                try {
                    stm = this.conn.createStatement();
                    Iterator batchedSqlIte = batchedSql.iterator();
                    int i = 0;
                    int f = 0;
                    while (batchedSqlIte.hasNext()) {
                        stm.addBatch((String)batchedSqlIte.next());
                        if (++i != 1000) continue;
                        f += stm.executeBatch().length;
                        stm.clearBatch();
                        i = 0;
                    }
                    n = stm.executeBatch().length + f;
                    if (stm == null) break block11;
                }
                catch (Throwable throwable) {
                    if (stm != null) {
                        stm.close();
                    }
                    throw throwable;
                }
                stm.close();
            }
            return n;
        }
        finally {
            if (this.autoClose) {
                this.close();
            }
        }
    }

    public void batch1Prepare(String sql) throws BusinessException, SQLException {
        if (sql == null || sql.length() == 0) {
            throw new BusinessException("No batched sql.");
        }
        this.batchCount = 0;
        this.batchExcuted = 0;
        if (this.pstBatch != null) {
            this.pstBatch.close();
            this.pstBatch = null;
        }
        this.pstBatch = this.conn.prepareStatement(sql);
    }

    public void batch2Add(List params) throws SQLException {
        if (this.pstBatch == null) {
            log.error((Object)"pstBatch is null, need call the method#batch1Prepare firstly!");
            return;
        }
        ++this.batchCount;
        if (this.batchCount == 1000) {
            this.batch3Execute();
            this.batchCount = 0;
        }
        for (int i = 0; i < params.size(); ++i) {
            this.setPreparedStatementObject(this.pstBatch, i + 1, params.get(i));
        }
        this.pstBatch.addBatch();
    }

    public int batch3Execute() throws SQLException {
        try {
            if (this.autoClose) {
                this.concernNum.incrementAndGet();
            }
            if (this.pstBatch == null) {
                log.error((Object)"pstBatch is null, need call the method#batch1Prepare and method#batch2Add before!");
                int n = this.batchExcuted;
                return n;
            }
            this.batchExcuted += this.pstBatch.executeBatch().length;
        }
        finally {
            if (this.autoClose) {
                this.close();
            }
        }
        return this.batchExcuted;
    }

    public FlipInfo findByPaging(String sql, FlipInfo fpi) throws BusinessException, SQLException {
        return this.findByPaging(sql, new ArrayList(), fpi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlipInfo findByPaging(String sql, List params, FlipInfo fpi) throws BusinessException, SQLException {
        try {
            int idx;
            if (this.autoClose) {
                this.concernNum.incrementAndGet();
            }
            if ((idx = sql.toLowerCase().indexOf(" from ")) == -1) {
                throw new BusinessException("Illegal sql that not contain from keyword.");
            }
            String rsql = sql;
            if (fpi.isNeedTotal()) {
                String countSql;
                String lowerCase = rsql.toLowerCase();
                if (lowerCase.indexOf("group by") != -1 || lowerCase.indexOf("distinct") != -1) {
                    int orderIdx = lowerCase.indexOf("order by");
                    String tempSql = rsql;
                    if (orderIdx != -1) {
                        tempSql = tempSql.substring(0, orderIdx);
                    }
                    countSql = "select count(1) from (" + tempSql + ") a";
                } else {
                    countSql = "select count(*) " + rsql.substring(idx);
                    int orderIdx = countSql.toLowerCase().indexOf("order by");
                    if (orderIdx != -1) {
                        countSql = countSql.substring(0, orderIdx);
                    }
                }
                this.execute(countSql, params);
                if (this.queryResult.next()) {
                    fpi.setTotal(this.queryResult.getInt(1));
                } else {
                    throw new BusinessException("Failed to query total record count.");
                }
            }
            if (fpi.isNeedTotal() && fpi.getTotal() == 0) {
                fpi.setPage(new Integer(0));
            } else if (fpi.getPage() < 1) {
                fpi.setPage(new Integer(1));
            } else if (fpi.getPage() > fpi.getPages()) {
                fpi.setPage(fpi.getPages());
            }
            if (fpi.getTotal() > 0 || !fpi.isNeedTotal()) {
                Dialect dialect;
                boolean useLimit;
                if (fpi.getSize() == -1) {
                    fpi.setPage(new Integer(1));
                    fpi.setSize(fpi.getTotal());
                }
                int startRow = fpi.getStartAt();
                int size = fpi.getSize();
                String sortField = fpi.getSortField();
                String sortOrder = fpi.getSortOrder();
                if (sortField != null && !"".equals(sortField)) {
                    StringBuilder sqlb = new StringBuilder(rsql);
                    if (rsql.indexOf("order by") == -1) {
                        sqlb.append(" order by ");
                    } else {
                        sqlb.append(",");
                    }
                    sqlb.append(sortField);
                    if (sortOrder != null) {
                        sqlb.append(" ").append(sortOrder);
                    }
                    rsql = sqlb.toString();
                }
                boolean useOffset = (useLimit = (dialect = JDBCAgent.getDialect()).supportsLimit()) && dialect.supportsLimitOffset();
                String pagingSql = null;
                if (!useLimit) {
                    throw new BusinessException("Limit not supported by current database type:" + dialect.getClass());
                }
                pagingSql = dialect.getLimitString(sql, useOffset ? startRow : 0, JDBCAgent.getMaxOrLimit(fpi, dialect));
                ArrayList pagingParams = new ArrayList(10);
                int col = 0;
                if (useLimit && dialect.bindLimitParametersFirst()) {
                    col += this.bindLimitParameters(dialect, pagingParams, col, fpi);
                }
                col += params.size();
                pagingParams.addAll(params);
                if (useLimit && !dialect.bindLimitParametersFirst()) {
                    col += this.bindLimitParameters(dialect, pagingParams, col, fpi);
                }
                this.execute(pagingSql, pagingParams);
                fpi.setData(this.resultSetToList(fpi, !useOffset && dialect.useMaxForLimit()));
            }
        }
        finally {
            if (this.autoClose) {
                this.close();
            }
        }
        return fpi;
    }

    public List<Map<String, Object>> findNamedSql(String namedSql) throws BusinessException {
        return this.findNamedSql(namedSql, Collections.EMPTY_MAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> findNamedSql(String namedSql, Map<String, Object> queryParams) throws BusinessException {
        try {
            if (this.autoClose) {
                this.concernNum.incrementAndGet();
            }
            FlipInfo fpi = new FlipInfo(0, -1);
            fpi.setNeedTotal(false);
            try {
                fpi = this.findNameByPaging(namedSql, queryParams, fpi);
            }
            catch (SQLException e) {
                log.error((Object)"\u6267\u884cSQL\u51fa\u9519", (Throwable)e);
                throw new BusinessException(e);
            }
            List list = fpi.getData();
            return list;
        }
        finally {
            if (this.autoClose) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlipInfo findNameByPaging(String namedSql, Map<String, Object> nameParams, FlipInfo fpi) throws BusinessException, SQLException {
        try {
            if (this.autoClose) {
                this.concernNum.incrementAndGet();
            }
            if (fpi.isNeedTotal()) {
                int total = this.count(namedSql, nameParams);
                fpi.setTotal(total);
            }
            Map.Entry<String, List<Object>> executeEntry = this.doPrepareNameQuery(namedSql.toString(), nameParams);
            if (fpi.getSize() == -1) {
                this.execute(executeEntry.getKey(), executeEntry.getValue());
                fpi.setData(this.resultSetToList(fpi, false));
            } else {
                Dialect dialect = JDBCAgent.getDialect();
                boolean useLimit = dialect.supportsLimit();
                boolean useOffset = useLimit && dialect.supportsLimitOffset();
                String sqlToUse = executeEntry.getKey();
                List<Object> params = executeEntry.getValue();
                String pagingSql = null;
                if (!useLimit) {
                    throw new BusinessException("Limit not supported by current database type:" + dialect.getClass());
                }
                pagingSql = dialect.getLimitString(sqlToUse, useOffset ? fpi.getStartAt() : 0, JDBCAgent.getMaxOrLimit(fpi, dialect));
                ArrayList<Object> pagingParams = new ArrayList<Object>(10);
                int col = 0;
                if (dialect.bindLimitParametersFirst()) {
                    col += this.bindLimitParameters(dialect, pagingParams, col, fpi);
                }
                col += params.size();
                pagingParams.addAll(params);
                if (!dialect.bindLimitParametersFirst()) {
                    col += this.bindLimitParameters(dialect, pagingParams, col, fpi);
                }
                this.execute(pagingSql, pagingParams);
                fpi.setData(this.resultSetToList(fpi, !useOffset && dialect.useMaxForLimit()));
            }
            FlipInfo flipInfo = fpi;
            return flipInfo;
        }
        finally {
            if (this.autoClose) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(String namedSql, Map<String, Object> nameParams) throws BusinessException, SQLException {
        try {
            int n;
            block16: {
                String countSql;
                if (this.autoClose) {
                    this.concernNum.incrementAndGet();
                }
                int idx = namedSql.toLowerCase().indexOf(" from ");
                String rsql = namedSql;
                String lowerCase = rsql.toLowerCase();
                if (lowerCase.indexOf("group by") != -1 || lowerCase.indexOf("distinct") != -1 || lowerCase.indexOf("union") != -1) {
                    int orderIdx = lowerCase.indexOf("order by");
                    String tempSql = rsql;
                    if (orderIdx != -1) {
                        tempSql = tempSql.substring(0, orderIdx);
                    }
                    countSql = "select count(1) from (" + tempSql + ") a";
                } else {
                    countSql = "select count(*) " + rsql.substring(idx);
                    int orderIdx = countSql.toLowerCase().indexOf("order by");
                    if (orderIdx != -1) {
                        countSql = countSql.substring(0, orderIdx);
                    }
                }
                try {
                    Map.Entry<String, List<Object>> executeEntry = this.doPrepareNameQuery(countSql, nameParams);
                    this.execute(executeEntry.getKey(), executeEntry.getValue());
                    int count = 0;
                    if (this.queryResult.next()) {
                        count = this.queryResult.getInt(1);
                    }
                    n = count;
                    if (this.queryResult == null) break block16;
                }
                catch (Throwable throwable) {
                    if (this.queryResult != null) {
                        Statement st = this.queryResult.getStatement();
                        this.queryResult.close();
                        if (st != null) {
                            st.close();
                        }
                    }
                    throw throwable;
                }
                Statement st = this.queryResult.getStatement();
                this.queryResult.close();
                if (st != null) {
                    st.close();
                }
            }
            return n;
        }
        finally {
            if (this.autoClose) {
                this.close();
            }
        }
    }

    private Map.Entry<String, List<Object>> doPrepareNameQuery(String namedSql, Map<String, Object> nameParams) {
        HashMap<String, Object> temp = new HashMap<String, Object>(nameParams);
        for (Map.Entry entry : temp.entrySet()) {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            if (!val.getClass().isArray()) continue;
            ArrayList newVal = new ArrayList();
            CollectionUtils.addAll(newVal, (Object[])((Object[])val));
            temp.put(key, newVal);
        }
        MapSqlParameterSource paramSource = new MapSqlParameterSource(temp);
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement((String)namedSql);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters((ParsedSql)parsedSql, (SqlParameterSource)paramSource);
        Object[] objs = NamedParameterUtils.buildValueArray((ParsedSql)parsedSql, (SqlParameterSource)paramSource, null);
        ArrayList<Object> params = new ArrayList<Object>();
        for (Object o : objs) {
            if (o instanceof Collection) {
                params.addAll((Collection)o);
                continue;
            }
            params.add(o);
        }
        return Pair.of((Object)sqlToUse, params);
    }

    private int bindLimitParameters(Dialect dialect, List pagingParams, int index, FlipInfo fi) throws SQLException {
        if (!dialect.supportsVariableLimit()) {
            return 0;
        }
        int firstRow = dialect.convertToFirstRowValue(fi.getStartAt().intValue());
        int lastRow = JDBCAgent.getMaxOrLimit(fi, dialect);
        boolean hasFirstRow = dialect.supportsLimitOffset() && (firstRow > 0 || dialect.forceLimitUsage());
        boolean reverse = dialect.bindLimitParametersInReverseOrder();
        if (hasFirstRow && !reverse) {
            pagingParams.add(index, firstRow);
        }
        pagingParams.add(index + (reverse || !hasFirstRow ? 0 : 1), lastRow);
        if (hasFirstRow && reverse) {
            pagingParams.add(index + 1, firstRow);
        }
        return hasFirstRow ? 2 : 1;
    }

    private static int getMaxOrLimit(FlipInfo fi, Dialect dialect) {
        int firstRow = dialect.convertToFirstRowValue(fi.getStartAt().intValue());
        int lastRow = fi.getSize();
        if (dialect.useMaxForLimit()) {
            return lastRow + firstRow;
        }
        return lastRow;
    }

    public List resultSetToList() throws SQLException {
        return this.resultSetToList(true);
    }

    public List resultSetToList(boolean lowercaseKey) throws SQLException {
        if (this.queryResult == null) {
            throw new InfrastructureException("\u672a\u8fdb\u884c\u8fc7\u4efb\u4f55\u67e5\u8be2\u64cd\u4f5c\uff01");
        }
        return this.resultSetToList(this.queryResult, lowercaseKey);
    }

    private List resultSetToList(FlipInfo fi, boolean useMaxForLimit) throws SQLException {
        ResultSet rs = this.queryResult;
        if (rs == null) {
            throw new InfrastructureException("\u672a\u8fdb\u884c\u8fc7\u4efb\u4f55\u67e5\u8be2\u64cd\u4f5c\uff01");
        }
        if (useMaxForLimit) {
            rs.setFetchSize(fi.getSize());
            if (fi.getStartAt() != 0) {
                rs.absolute(fi.getStartAt());
            }
        }
        return this.resultSetToList(rs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List resultSetToList(ResultSet rs, boolean lowercaseKey) throws SQLException {
        if (rs == null) {
            throw new InfrastructureException("\u67e5\u8be2\u7ed3\u679c\u96c6\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            ArrayList dataList = new ArrayList();
            int columns = rsmd.getColumnCount();
            while (rs.next()) {
                LinkedHashMap<String, Timestamp> map = new LinkedHashMap<String, Timestamp>();
                for (int j = 1; j <= columns; ++j) {
                    String columnName;
                    String string = columnName = lowercaseKey ? rsmd.getColumnLabel(j).toLowerCase() : rsmd.getColumnLabel(j);
                    Object value = rsmd.getColumnType(j) == 93 ? rs.getTimestamp(columnName) : (rsmd.getColumnType(j) == 2005 ? JDBCAgent.extractClobString(rs, columnName) : rs.getObject(columnName));
                    map.put(columnName, (Timestamp)value);
                }
                dataList.add(map);
            }
            if (dataList != null && dataList.size() > 500) {
                StringBuilder warnStrBuilder = new StringBuilder();
                warnStrBuilder.append("\u67e5\u8be2\u8bb0\u5f55\u6570\u5927\u4e8e\u9600\u503c\uff08");
                warnStrBuilder.append(500);
                warnStrBuilder.append(") \u5f53\u524d\u8bb0\u5f55\u6570 ");
                warnStrBuilder.append(dataList.size());
                log.warn((Object)warnStrBuilder.toString());
            }
            ArrayList arrayList = dataList;
            return arrayList;
        }
        finally {
            if (rs != null) {
                Statement st = rs.getStatement();
                rs.close();
                if (st != null) {
                    st.close();
                }
            }
        }
    }

    public Map resultSetToMap() throws BusinessException, SQLException {
        if (this.queryResult == null) {
            throw new InfrastructureException("\u672a\u8fdb\u884c\u8fc7\u4efb\u4f55\u67e5\u8be2\u64cd\u4f5c\uff01");
        }
        return this.resultSetToMap(this.queryResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map resultSetToMap(ResultSet rs) throws BusinessException, SQLException {
        if (rs == null) {
            throw new InfrastructureException("\u67e5\u8be2\u7ed3\u679c\u96c6\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columns = rsmd.getColumnCount();
            if (rs.isAfterLast()) {
                throw new BusinessException("end of resultset!");
            }
            LinkedMap map = new LinkedMap();
            if (rs.isBeforeFirst()) {
                rs.next();
                for (int j = 1; j <= columns; ++j) {
                    String columnName = rsmd.getColumnLabel(j).toLowerCase();
                    Object value = rsmd.getColumnType(j) == 93 ? rs.getTimestamp(columnName) : (rsmd.getColumnType(j) == 2005 ? JDBCAgent.extractClobString(rs, columnName) : rs.getObject(columnName));
                    map.put(columnName, value);
                }
            }
            LinkedMap linkedMap = map;
            return linkedMap;
        }
        finally {
            Statement st = rs.getStatement();
            rs.close();
            if (st != null) {
                st.close();
            }
        }
    }

    @Override
    public void close() {
        CTPHibernateDaoSupport dao;
        if (this.autoClose && this.concernNum.decrementAndGet() > 0) {
            return;
        }
        try {
            if (this.queryResult != null) {
                this.queryResult.close();
                this.queryResult = null;
            }
        }
        catch (SQLException e) {
            log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (this.stSet.size() > 0) {
            try {
                Iterator ite = this.stSet.iterator();
                while (ite.hasNext()) {
                    ((Statement)ite.next()).close();
                }
                this.stSet.clear();
            }
            catch (Exception e) {
                log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (this.pstBatch != null) {
            try {
                this.pstBatch.close();
                this.pstBatch = null;
                this.batchCount = 0;
                this.batchExcuted = 0;
            }
            catch (SQLException e) {
                log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        boolean close = this.raw;
        boolean isSessionTransactional = false;
        Session session = null;
        if (!this.raw && (dao = DBAgent.currentHibernateDaoSupport()) != null) {
            session = dao.currentSession();
            isSessionTransactional = SessionFactoryUtils.isSessionTransactional((Session)session, (SessionFactory)session.getSessionFactory());
            boolean bl = close = !isSessionTransactional;
        }
        if (close) {
            if (this.conn != null) {
                try {
                    this.conn.close();
                    this.conn = null;
                }
                catch (SQLException e) {
                    log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (!this.raw) {
                JDBCAgent.release();
            }
        }
    }

    @Deprecated
    public static void release() {
    }

    public String getDBUserName() throws SQLException {
        return this.conn.getMetaData().getUserName();
    }

    public String getCatalog() throws SQLException {
        String catalog = this.conn.getCatalog();
        if (Strings.isEmpty(catalog)) {
            catalog = this.getDBUserName();
        }
        return catalog;
    }

    public static Dialect getDialect() {
        if (dialect != null) {
            return dialect;
        }
        SessionImpl session = (SessionImpl)JDBCAgent.currentSession();
        if (session != null) {
            dialect = session.getFactory().getDialect();
        }
        return dialect;
    }

    public static String getDBType() {
        String dbName = JDBCAgent.getDatabaseType();
        if (dbName != null) {
            dbName = dbName.toLowerCase();
        }
        return dbName;
    }

    public static String getDatabaseType() {
        return (String)AppContext.getCache("DATABASE_NAME");
    }

    public static boolean isSQLServerRuntime() {
        String dbType = JDBCAgent.getDBType();
        if (dbType == null) {
            return false;
        }
        return dbType.indexOf("microsoft") > -1;
    }

    public static boolean isOracleRuntime() {
        String dbType = JDBCAgent.getDBType();
        if (dbType == null) {
            return false;
        }
        return dbType.indexOf("oracle") > -1;
    }

    public static boolean isMySQLRuntime() {
        String dbType = JDBCAgent.getDBType();
        if (dbType == null) {
            return false;
        }
        return dbType.indexOf("mysql") > -1;
    }

    public static boolean isPostgreSQLRuntime() {
        String dbType = JDBCAgent.getDBType();
        if (dbType == null) {
            return false;
        }
        return dbType.indexOf("postgresql") > -1;
    }

    public static boolean isDMRuntime() {
        String dbType = JDBCAgent.getDBType();
        if (dbType == null) {
            return false;
        }
        return dbType.indexOf("dm") > -1;
    }

    public static boolean isKingBaseesRunTime() {
        String dbType = JDBCAgent.getDBType();
        return "kingbasees".equals(dbType);
    }

    public static Object executeProcedure(String callString, CallableStatementCallback action) {
        JdbcTemplate jt = new JdbcTemplate();
        jt.setDataSource(JDBCAgent.getDataSource());
        log.debug((Object)callString);
        return jt.execute(callString, action);
    }

    public static Object executeProcedure(String dsName, String callString, CallableStatementCallback action) {
        JdbcTemplate jt = new JdbcTemplate();
        jt.setDataSource(JDBCAgent.getDataSource(dsName));
        log.debug((Object)callString);
        return jt.execute(callString, action);
    }

    public static Object executePreparedStatement(String preparedString, PreparedStatementCallback action) {
        JdbcTemplate jt = new JdbcTemplate();
        jt.setDataSource(JDBCAgent.getDataSource());
        log.debug((Object)preparedString);
        return jt.execute(preparedString, action);
    }

    public static Object executePreparedStatement(String dsName, String preparedString, PreparedStatementCallback action) {
        JdbcTemplate jt = new JdbcTemplate();
        jt.setDataSource(JDBCAgent.getDataSource(dsName));
        log.debug((Object)preparedString);
        return jt.execute(preparedString, action);
    }

    @Deprecated
    public static Connection getConnection() {
        JDBCAgent.aopLock();
        Session session = JDBCAgent.currentSession();
        return session.connection();
    }

    public static Connection getRawConnection() throws SQLException {
        return JDBCAgent.getRawConnection(CtpDynamicDataSource.getDataSourceKey());
    }

    public static Connection getRawConnection(String dsName) throws SQLException {
        DataSource ds = (DataSource)AppContext.getBean(dsName);
        if (ds == null) {
            ds = (DataSource)AppContext.getBean("dataSource");
        }
        if (ds == null) {
            try {
                InitialContext ctx = new InitialContext();
                ds = (DataSource)ctx.lookup(dsName);
            }
            catch (NamingException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return ds.getConnection();
    }

    public static DataSource getDataSource() {
        return JDBCAgent.getDataSource("dataSource");
    }

    public static DataSource getDataSource(String dsName) {
        return (DataSource)AppContext.getBean(dsName);
    }

    private static Session currentSession() {
        JDBCAgent.aopLock();
        CTPHibernateDaoSupport daoSupport = DBAgent.currentHibernateDaoSupport();
        return daoSupport == null ? null : daoSupport.currentSession();
    }

    private static void aopLock() {
    }

    public static void loadSqlInFile() {
        String dbName = (String)AppContext.getCache("DATABASE_NAME");
        if (dbName == null || "".equals(dbName)) {
            throw new InfrastructureException("\u672a\u6b63\u786e\u521d\u59cb\u5316\u6570\u636e\u5e93\u7c7b\u578b\u6807\u8bc6\uff01");
        }
        String cacheKey = dbName + "_SQL_CACHE";
        Properties sqlMap = new Properties();
        AppContext.putCache(cacheKey, sqlMap);
        File sqlDir = new File(AppContext.getCfgHome(), "sql");
        JDBCAgent.loadSqlInFile(dbName, sqlMap, sqlDir);
        Object obj = MclclzUtil.invoke(c1, (String)"getInstance");
        List defs = (List)MclclzUtil.invoke(c1, (String)"getPluginDefinitions", null, (Object)obj, null);
        for (PluginDefinition def : defs) {
            JDBCAgent.loadSqlInFile(dbName, sqlMap, new File(def.getPluginFoler(), "sql"));
        }
    }

    public static String getSqlInFile(String sqlKey) throws BusinessException {
        String sql;
        String dbName = (String)AppContext.getCache("DATABASE_NAME");
        if (dbName == null || "".equals(dbName)) {
            throw new InfrastructureException("\u672a\u6b63\u786e\u521d\u59cb\u5316\u6570\u636e\u5e93\u7c7b\u578b\u6807\u8bc6\uff01");
        }
        String cacheKey = dbName + "_SQL_CACHE";
        Properties sqlMap = (Properties)AppContext.getCache(cacheKey);
        if (sqlMap == null) {
            JDBCAgent.loadSqlInFile();
            sqlMap = (Properties)AppContext.getCache(cacheKey);
            if (sqlMap == null) {
                throw new InfrastructureException("\u4e0d\u5b58\u5728\u53ef\u7528\u7684SQL\u914d\u7f6e\uff1a" + dbName);
            }
        }
        if ((sql = sqlMap.getProperty(sqlKey)) == null) {
            throw new BusinessException("SQL not found with key:" + sqlKey);
        }
        return sql;
    }

    private static void loadSqlInFile(String dbName, Properties propsCache, File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            for (File f : files = dir.listFiles()) {
                if (f.isFile()) {
                    if (!f.getName().startsWith(dbName) && !f.getName().startsWith("ALL")) continue;
                    propsCache.putAll((Map<?, ?>)PropertiesLoader.load(f));
                    continue;
                }
                JDBCAgent.loadSqlInFile(dbName, propsCache, f);
            }
        }
    }

    public void executeSqlFile(String sqlKey, List params) throws BusinessException, IOException, SQLException {
        String sql = JDBCAgent.getSqlInFile(sqlKey);
        this.execute(sql, params);
    }

    public void executeSqlFile(String sqlKey, Map<String, Object> params) throws BusinessException, IOException, SQLException {
        String sql = JDBCAgent.getSqlInFile(sqlKey);
        this.executeNamedSql(sql, params);
    }

    public void executeNamedSql(String namedSql, Map<String, Object> params) throws BusinessException, IOException, SQLException {
        String exeSql = new String(namedSql);
        ArrayList<Object> exeParam = new ArrayList<Object>();
        Matcher matcher = paramRegPattern.matcher(exeSql.toString());
        StringBuffer finalSql = new StringBuffer();
        while (matcher.find()) {
            String left = matcher.group(1);
            String field = matcher.group(2);
            Object val = params.get(field.substring(1));
            StringBuilder replaceStr = new StringBuilder(left).append("?");
            if (val instanceof Collection) {
                Collection valColl = (Collection)val;
                for (int i = 1; i < valColl.size(); ++i) {
                    replaceStr.append(",?");
                }
                exeParam.addAll(valColl);
            } else {
                exeParam.add(val);
            }
            matcher.appendReplacement(finalSql, replaceStr.toString());
        }
        if (finalSql.length() > 0) {
            matcher.appendTail(finalSql);
            exeSql = finalSql.toString();
        }
        this.execute(exeSql, exeParam);
    }

    public void executeSqlFile(String sqlKey) throws BusinessException, IOException, SQLException {
        this.executeSqlFile(sqlKey, new ArrayList());
    }

    private static String extractClobString(ResultSet rs, String columnName) throws SQLException {
        return JDBCAgent.clobToString(rs.getClob(columnName));
    }

    public static String clobToString(Clob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        Reader is = clob.getCharacterStream();
        BufferedReader br = new BufferedReader(is);
        try {
            String s = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (s != null) {
                sb.append(s);
                s = br.readLine();
                if (s == null) continue;
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), e);
        }
        finally {
            try {
                br.close();
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static List<List> splitList(List entityList, Integer groupSize) {
        List<List> result = null;
        if (Strings.isNotEmpty(entityList)) {
            if (groupSize == null || groupSize <= 0) {
                groupSize = 1000;
            }
            int cycleNum = entityList.size() % groupSize == 0 ? entityList.size() / groupSize : entityList.size() / groupSize + 1;
            result = new ArrayList<List>(cycleNum);
            for (int i = 0; i < cycleNum; ++i) {
                if (i + 1 < cycleNum) {
                    result.add(entityList.subList(i * groupSize, (i + 1) * groupSize));
                    continue;
                }
                result.add(entityList.subList(i * groupSize, entityList.size()));
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    public static final void putTrackTableInfo(JMSQLOperation aSQLOperation, String ... aTableNames) {
        JMProxyDriver.getTrackCallback().putTrackTableInfo(aSQLOperation, aTableNames);
    }

    public static final String toChar(String fieldName) {
        StringBuilder sql = new StringBuilder();
        if (JDBCAgent.isOracleRuntime() || JDBCAgent.isDMRuntime()) {
            sql.append(" TO_CHAR(").append(fieldName).append(")");
        } else if (JDBCAgent.isPostgreSQLRuntime()) {
            sql.append(" cast(").append(fieldName).append(" as varchar)");
        } else if (JDBCAgent.isSQLServerRuntime()) {
            sql.append(" cast(").append(fieldName).append(" as varchar)");
        } else {
            sql.append(" concat(").append(fieldName).append(")");
        }
        return sql.toString();
    }
}

