/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import java.util.Collection;
import java.util.Stack;

public class LRUStack<E>
extends Stack<E> {
    private static final long serialVersionUID = -632240339210133087L;
    private final int maxCapacity;

    public LRUStack(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    protected boolean removeEldestEntry() {
        return this.size() > this.maxCapacity;
    }

    @Override
    public E push(E e) {
        if (this.contains(e)) {
            this.removeElement(e);
        }
        super.insertElementAt(e, 0);
        if (this.removeEldestEntry()) {
            this.removeElementAt(this.size() - 1);
        }
        return e;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] a = c.toArray();
        for (int i = a.length - 1; i >= 0; --i) {
            this.push(a[i]);
        }
        return a.length != 0;
    }
}

