/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Datetimes;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class StatUtil {
    private static final Log log = CtpLogFactory.getLog(StatUtil.class);

    public static Map<String, Timestamp> getDefaultStatDate() {
        Map<String, Timestamp> defaultMap = StatUtil.getStatDate(null);
        return defaultMap;
    }

    public static Map<String, Timestamp> getStatDate(String str) {
        GregorianCalendar cal = new GregorianCalendar();
        Date date = null;
        if (str != null) {
            String pattern = "yyyy-MM-dd hh:mm:ss";
            date = Datetimes.parse(str, pattern);
        }
        if (date == null) {
            date = new Date();
        }
        cal.setTime(date);
        int dayofmonth = cal.get(5);
        int year = cal.get(1);
        int month = cal.get(2);
        int daysofmonth = ((Calendar)cal).getActualMaximum(5);
        GregorianCalendar cal2 = new GregorianCalendar(year, month, 1, 0, 0, 0);
        GregorianCalendar cal3 = new GregorianCalendar(year, month, daysofmonth, 23, 59, 59);
        Date date2 = cal2.getTime();
        Date date3 = cal3.getTime();
        Date date4 = Datetimes.getFirstDayInWeek(date);
        Date date5 = Datetimes.getLastDayInWeek(date);
        GregorianCalendar cal6 = new GregorianCalendar(year, month, dayofmonth, 0, 0, 0);
        GregorianCalendar cal7 = new GregorianCalendar(year, month, dayofmonth, 23, 59, 59);
        Date date6 = cal6.getTime();
        Date date7 = cal7.getTime();
        Timestamp stamp2 = new Timestamp(date2.getTime());
        Timestamp stamp3 = new Timestamp(date3.getTime());
        Timestamp stamp4 = new Timestamp(date4.getTime());
        Timestamp stamp5 = new Timestamp(date5.getTime());
        Timestamp stamp6 = new Timestamp(date6.getTime());
        Timestamp stamp7 = new Timestamp(date7.getTime());
        HashMap<String, Timestamp> map = new HashMap<String, Timestamp>();
        map.put("BeginOfMonth", stamp2);
        map.put("EndOfMonth", stamp3);
        map.put("BeginOfWeek", stamp4);
        map.put("EndOfWeek", stamp5);
        map.put("BeginOfDay", stamp6);
        map.put("EndOfDay", stamp7);
        return map;
    }

    public static Map getSpecificDate(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return null;
        }
        String pattern = "yyyy-MM-dd hh:mm:ss";
        Date date1 = null;
        Date date2 = null;
        HashMap<String, Timestamp> map = new HashMap<String, Timestamp>();
        date1 = Datetimes.parse(str1, pattern);
        date2 = Datetimes.parse(str2, pattern);
        Timestamp stamp1 = new Timestamp(date1.getTime());
        Timestamp stamp2 = new Timestamp(date2.getTime());
        map.put("BeginOfTime", stamp1);
        map.put("EndOfTime", stamp2);
        return map;
    }

    public static Map getQuarterDate(int year, int quarter) {
        if (quarter < 1 || quarter > 4) {
            return null;
        }
        Calendar cal1 = null;
        Calendar cal2 = null;
        HashMap<String, Timestamp> map = new HashMap<String, Timestamp>();
        switch (quarter) {
            case 1: {
                cal1 = new GregorianCalendar(year, 0, 1, 0, 0, 0);
                cal2 = new GregorianCalendar(year, 2, 31, 23, 59, 59);
                break;
            }
            case 2: {
                cal1 = new GregorianCalendar(year, 3, 1, 0, 0, 0);
                cal2 = new GregorianCalendar(year, 5, 30, 23, 59, 59);
                break;
            }
            case 3: {
                cal1 = new GregorianCalendar(year, 6, 1, 0, 0, 0);
                cal2 = new GregorianCalendar(year, 8, 30, 23, 59, 59);
                break;
            }
            case 4: {
                cal1 = new GregorianCalendar(year, 9, 1, 0, 0, 0);
                cal2 = new GregorianCalendar(year, 11, 30, 23, 59, 59);
                break;
            }
        }
        if (cal1 == null || cal2 == null) {
            return null;
        }
        Date date1 = cal1.getTime();
        Date date2 = cal2.getTime();
        Timestamp stamp1 = new Timestamp(date1.getTime());
        Timestamp stamp2 = new Timestamp(date2.getTime());
        map.put("BeginOfQuarter", stamp1);
        map.put("EndOfQuarter", stamp2);
        return map;
    }

    public static Map getStatDate() {
        Date today = new Date();
        Timestamp beginOfDay = new Timestamp(Datetimes.getTodayFirstTime().getTime());
        Timestamp endOfDay = new Timestamp(Datetimes.getTodayLastTime().getTime());
        Timestamp beginOfWeek = new Timestamp(Datetimes.getFirstDayInWeek(today).getTime());
        Timestamp endOfWeek = new Timestamp(Datetimes.getLastDayInWeek(today).getTime());
        Timestamp beginOfMonth = new Timestamp(Datetimes.getFirstDayInMonth(today).getTime());
        Timestamp endOfMonth = new Timestamp(Datetimes.getLastDayInMonth(today).getTime());
        Timestamp beginOfQuarter = new Timestamp(Datetimes.getFirstDayInSeason(today).getTime());
        Timestamp endOfQuarter = new Timestamp(Datetimes.getLastDayInSeason(today).getTime());
        HashMap<String, Timestamp> map = new HashMap<String, Timestamp>();
        map.put("BeginOfDay", beginOfDay);
        map.put("EndOfDay", endOfDay);
        map.put("BeginOfWeek", beginOfWeek);
        map.put("EndOfWeek", endOfWeek);
        map.put("BeginOfMonth", beginOfMonth);
        map.put("EndOfMonth", endOfMonth);
        map.put("BeginOfQuarter", beginOfQuarter);
        map.put("EndOfQuarter", endOfQuarter);
        return map;
    }
}

